"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourceProfileService = exports.DataSourceCategory = void 0;
var _profile_service = require("../profile_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Indicates the category of the data source (e.g. logs, alerts, etc.)
 */
let DataSourceCategory = exports.DataSourceCategory = /*#__PURE__*/function (DataSourceCategory) {
  DataSourceCategory["Traces"] = "traces";
  DataSourceCategory["Logs"] = "logs";
  DataSourceCategory["Default"] = "default";
  return DataSourceCategory;
}({});
/**
 * The data source profile interface
 */
/**
 * Parameters for the data source profile provider `resolve` method
 */
/**
 * The resulting context object returned by the data source profile provider `resolve` method
 */
class DataSourceProfileService extends _profile_service.AsyncProfileService {
  constructor() {
    super({
      profileId: 'default-data-source-profile',
      category: DataSourceCategory.Default
    });
  }
}
exports.DataSourceProfileService = DataSourceProfileService;