"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionBar = ActionBar;
require("./_action_bar.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _action_bar_warning = require("./action_bar_warning");
var _context = require("../../services/context");
var _constants = require("../../services/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function ActionBar({
  defaultStepSize,
  docCount,
  docCountAvailable,
  isDisabled,
  isLoading,
  onChangeCount,
  type
}) {
  const showWarning = !isDisabled && !isLoading && docCountAvailable < docCount;
  const isSuccessor = type === _context.SurrDocType.SUCCESSORS;
  const [newDocCount, setNewDocCount] = (0, _react.useState)(docCount);
  const canLoadMore = defaultStepSize > 0 || newDocCount !== docCount;
  const isValid = value => value >= _constants.MIN_CONTEXT_SIZE && value <= _constants.MAX_CONTEXT_SIZE;
  const onSubmit = ev => {
    ev.preventDefault();
    if (newDocCount !== docCount && isValid(newDocCount)) {
      onChangeCount(type, newDocCount);
    }
  };
  (0, _react.useEffect)(() => {
    if (newDocCount !== docCount && newDocCount === 0) {
      setNewDocCount(docCount);
    }
  }, [docCount, newDocCount]);
  return /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: onSubmit
  }, isSuccessor && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), isSuccessor && showWarning && /*#__PURE__*/_react.default.createElement(_action_bar_warning.ActionBarWarning, {
    docCount: docCountAvailable,
    type: type
  }), isSuccessor && showWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `${type}LoadMoreButton`,
    isDisabled: isDisabled || !canLoadMore,
    isLoading: isLoading,
    onClick: () => {
      const value = newDocCount + defaultStepSize;
      if (isValid(value)) {
        setNewDocCount(value);
        onChangeCount(type, value);
      }
    },
    flush: "right"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.context.loadButtonLabel",
    defaultMessage: "Load"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": isSuccessor ? _i18n.i18n.translate('discover.context.olderDocumentsAriaLabel', {
      defaultMessage: 'Number of older documents'
    }) : _i18n.i18n.translate('discover.context.newerDocumentsAriaLabel', {
      defaultMessage: 'Number of newer documents'
    }),
    compressed: true,
    className: "cxtSizePicker",
    "data-test-subj": `${type}CountPicker`,
    disabled: isDisabled,
    min: _constants.MIN_CONTEXT_SIZE,
    max: _constants.MAX_CONTEXT_SIZE,
    onChange: ev => {
      setNewDocCount(ev.target.valueAsNumber);
    },
    onBlur: () => {
      if (newDocCount !== docCount && isValid(newDocCount)) {
        onChangeCount(type, newDocCount);
      }
    },
    type: "number",
    value: newDocCount >= 0 ? newDocCount : ''
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "center"
  }, isSuccessor ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.context.olderDocumentsDescription",
    defaultMessage: "older documents"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.context.newerDocumentsDescription",
    defaultMessage: "newer documents"
  })))), !isSuccessor && showWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), !isSuccessor && showWarning && /*#__PURE__*/_react.default.createElement(_action_bar_warning.ActionBarWarning, {
    docCount: docCountAvailable,
    type: type
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
}