"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = validate;
var _alertingComparators = require("@kbn/alerting-comparators");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const invalidThresholdValue = value => !value || value && (isNaN(value) || value < 0 || value > 100);
function validate(ruleParams) {
  var _ruleParams$threshold, _ruleParams$threshold2;
  const errors = {};
  if (!ruleParams.searchConfiguration) {
    return {
      errors: {
        searchConfiguration: [_i18n.i18n.translate('xpack.datasetQuality.alerts.validation.error.requiredSearchConfiguration', {
          defaultMessage: 'Search source configuration is required.'
        })]
      }
    };
  }
  if (!ruleParams.searchConfiguration.index) {
    return {
      errors: {
        searchConfiguration: [_i18n.i18n.translate('xpack.datasetQuality.alerts.validation.error.requiredDataViewText', {
          defaultMessage: 'Data view is required.'
        })]
      }
    };
  }
  if (!ruleParams.threshold || invalidThresholdValue((_ruleParams$threshold = ruleParams.threshold) === null || _ruleParams$threshold === void 0 ? void 0 : _ruleParams$threshold[0])) {
    errors.threshold0 = [_i18n.i18n.translate('xpack.datasetQuality.alerts.validation.threshold', {
      defaultMessage: 'A valid percentage threshold is required (0-100).'
    })];
  }
  if ((ruleParams.comparator === _alertingComparators.COMPARATORS.BETWEEN || ruleParams.comparator === _alertingComparators.COMPARATORS.NOT_BETWEEN) && invalidThresholdValue((_ruleParams$threshold2 = ruleParams.threshold) === null || _ruleParams$threshold2 === void 0 ? void 0 : _ruleParams$threshold2[1])) {
    errors.threshold1 = [_i18n.i18n.translate('xpack.datasetQuality.alerts.validation.threshold', {
      defaultMessage: 'A valid percentage threshold is required (0-100).'
    })];
  }
  return {
    errors
  };
}