"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetRedirectLinkTelemetry = exports.useDatasetDetailsRedirectLinkTelemetry = void 0;
var _react = require("react");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _use_dataset_telemetry = require("./use_dataset_telemetry");
var _use_dataset_details_telemetry = require("./use_dataset_details_telemetry");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDatasetRedirectLinkTelemetry = ({
  rawName,
  query
}) => {
  const {
    trackDatasetNavigated
  } = (0, _use_dataset_telemetry.useDatasetTelemetry)();
  const sendTelemetry = (0, _react.useCallback)(() => {
    const isIgnoredFilter = query ? JSON.stringify(query).includes('_ignored') : false;
    trackDatasetNavigated(rawName, isIgnoredFilter);
  }, [query, rawName, trackDatasetNavigated]);
  return {
    sendTelemetry
  };
};
exports.useDatasetRedirectLinkTelemetry = useDatasetRedirectLinkTelemetry;
const useDatasetDetailsRedirectLinkTelemetry = ({
  query,
  navigationSource
}) => {
  const {
    services: {
      share
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const logsExplorerLocator = share.url.locators.get(_deeplinksObservability.SINGLE_DATASET_LOCATOR_ID);
  const isLogsExplorer = !!logsExplorerLocator;
  const {
    trackDetailsNavigated,
    navigationTargets
  } = (0, _use_dataset_details_telemetry.useDatasetDetailsTelemetry)();
  const sendTelemetry = (0, _react.useCallback)(() => {
    const isIgnoredFilter = query ? JSON.stringify(query).includes('_ignored') : false;
    const target = isLogsExplorer ? navigationTargets.LogsExplorer : navigationTargets.Discover;
    trackDetailsNavigated(target, navigationSource, isIgnoredFilter);
  }, [query, isLogsExplorer, navigationTargets.LogsExplorer, navigationTargets.Discover, trackDetailsNavigated, navigationSource]);
  return {
    sendTelemetry
  };
};
exports.useDatasetDetailsRedirectLinkTelemetry = useDatasetDetailsRedirectLinkTelemetry;