"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetQualityFilters = void 0;
var _react = require("@xstate/react");
var _react2 = require("react");
var _integration = require("../../common/data_streams_stats/integration");
var _context = require("../components/dataset_quality/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDatasetQualityFilters = () => {
  const {
    service
  } = (0, _context.useDatasetQualityContext)();
  const isLoading = (0, _react.useSelector)(service, state => state.matches('initializing') || state.matches('main.integrations.fetching') && (state.matches('main.stats.datasets.fetching') || state.matches('main.stats.degradedDocs.fetching')));
  const authorizedDatasetTypes = (0, _react.useSelector)(service, state => !state.matches('initializing') ? state.context.authorizedDatasetTypes : []);
  const {
    timeRange,
    integrations: selectedIntegrations,
    namespaces: selectedNamespaces,
    types: selectedTypes,
    qualities: selectedQualities,
    query: selectedQuery
  } = (0, _react.useSelector)(service, state => state.context.filters);
  const datasets = (0, _react.useSelector)(service, state => state.context.datasets);
  const integrations = (0, _react.useSelector)(service, state => state.context.integrations);
  const {
    namespaces,
    qualities,
    filteredIntegrations
  } = (0, _react2.useMemo)(() => datasets.reduce((acc, dataset) => {
    var _dataset$integration$, _dataset$integration;
    return {
      namespaces: [...new Set([...acc.namespaces, dataset.namespace])],
      qualities: [...new Set([...acc.qualities, dataset.quality])],
      filteredIntegrations: [...new Set([...acc.filteredIntegrations, (_dataset$integration$ = (_dataset$integration = dataset.integration) === null || _dataset$integration === void 0 ? void 0 : _dataset$integration.name) !== null && _dataset$integration$ !== void 0 ? _dataset$integration$ : 'none'])]
    };
  }, {
    namespaces: [],
    qualities: [],
    filteredIntegrations: []
  }), [datasets]);
  const onTimeChange = (0, _react2.useCallback)(selectedTime => {
    if (selectedTime.isInvalid) {
      return;
    }
    service.send({
      type: 'UPDATE_TIME_RANGE',
      timeRange: {
        ...timeRange,
        from: selectedTime.start,
        to: selectedTime.end
      }
    });
  }, [service, timeRange]);
  const onRefresh = (0, _react2.useCallback)(() => {
    service.send({
      type: 'REFRESH_DATA'
    });
  }, [service]);
  const onRefreshChange = (0, _react2.useCallback)(({
    refreshInterval,
    isPaused
  }) => {
    service.send({
      type: 'UPDATE_TIME_RANGE',
      timeRange: {
        ...timeRange,
        refresh: {
          pause: isPaused,
          value: refreshInterval
        }
      }
    });
  }, [service, timeRange]);
  const integrationItems = (0, _react2.useMemo)(() => {
    var _integrations$reduce;
    const integrationsMap = (_integrations$reduce = integrations === null || integrations === void 0 ? void 0 : integrations.reduce((acc, integration) => ({
      ...acc,
      [integration.name]: integration
    }), {})) !== null && _integrations$reduce !== void 0 ? _integrations$reduce : {};
    integrationsMap.none = _integration.Integration.create({
      name: 'none',
      title: 'None'
    });
    return filteredIntegrations.map(name => {
      var _integrationsMap$name;
      return {
        ...integrationsMap[name],
        label: (_integrationsMap$name = integrationsMap[name]) === null || _integrationsMap$name === void 0 ? void 0 : _integrationsMap$name.title,
        checked: selectedIntegrations.includes(name) ? 'on' : undefined
      };
    });
  }, [integrations, filteredIntegrations, selectedIntegrations]);
  const onIntegrationsChange = (0, _react2.useCallback)(newIntegrationItems => {
    service.send({
      type: 'UPDATE_INTEGRATIONS',
      integrations: newIntegrationItems.filter(integration => integration.checked === 'on').map(integration => integration.name)
    });
  }, [service]);
  const namespaceItems = (0, _react2.useMemo)(() => {
    const uniqueNamespaces = [...new Set(namespaces)];
    return uniqueNamespaces.map(namespace => ({
      label: namespace,
      checked: selectedNamespaces.includes(namespace) ? 'on' : undefined
    }));
  }, [namespaces, selectedNamespaces]);
  const onNamespacesChange = (0, _react2.useCallback)(newNamespaceItems => {
    service.send({
      type: 'UPDATE_NAMESPACES',
      namespaces: newNamespaceItems.filter(namespace => namespace.checked === 'on').map(namespace => namespace.label)
    });
  }, [service]);
  const qualityItems = (0, _react2.useMemo)(() => {
    const uniqueQualities = [...new Set(qualities)];
    return uniqueQualities.map(quality => ({
      label: quality,
      checked: selectedQualities.includes(quality) ? 'on' : undefined
    }));
  }, [qualities, selectedQualities]);
  const onQualitiesChange = (0, _react2.useCallback)(newQualityItems => {
    service.send({
      type: 'UPDATE_QUALITIES',
      qualities: newQualityItems.filter(quality => quality.checked === 'on').map(quality => quality.label)
    });
  }, [service]);
  const typeItems = (0, _react2.useMemo)(() => {
    return authorizedDatasetTypes.map(type => ({
      label: type,
      checked: selectedTypes.includes(type) ? 'on' : undefined
    }));
  }, [authorizedDatasetTypes, selectedTypes]);
  const onTypesChange = (0, _react2.useCallback)(newTypeItems => {
    service.send({
      type: 'UPDATE_TYPES',
      types: newTypeItems.filter(quality => quality.checked === 'on').map(type => type.label)
    });
  }, [service]);
  const onQueryChange = (0, _react2.useCallback)(query => {
    service.send({
      type: 'UPDATE_QUERY',
      query
    });
  }, [service]);
  return {
    timeRange,
    onTimeChange,
    onRefresh,
    onRefreshChange,
    integrations: integrationItems,
    namespaces: namespaceItems,
    qualities: qualityItems,
    types: typeItems,
    authorizedDatasetTypes,
    onIntegrationsChange,
    onNamespacesChange,
    onQualitiesChange,
    onTypesChange,
    isLoading,
    selectedQuery,
    onQueryChange
  };
};
exports.useDatasetQualityFilters = useDatasetQualityFilters;