"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = Overview;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
var _aggregation_not_supported = require("./aggregation_not_supported");
var _quality_issues = require("./quality_issues");
var _failure_store_warning = require("../../failure_store/failure_store_warning");
var _use_kibana = require("../../../utils/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OverviewHeader = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./header'))));
const Summary = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./summary'))));
const DocumentTrends = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./document_trends'))));
function Overview() {
  const {
    dataStream,
    isNonAggregatable,
    canUserReadFailureStore,
    hasFailureStore,
    updateTimeRange,
    loadingState: {
      dataStreamSettingsLoading
    }
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const {
    services: {
      share: {
        url: urlService
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const locator = urlService.locators.get('INDEX_MANAGEMENT_LOCATOR_ID');
  const locatorParams = {
    page: 'data_streams_details',
    dataStreamName: dataStream
  };
  const [lastReloadTime, setLastReloadTime] = (0, _react.useState)(Date.now());
  const handleRefresh = (0, _react.useCallback)(refreshProps => {
    updateTimeRange(refreshProps);
    setLastReloadTime(Date.now());
  }, [updateTimeRange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isNonAggregatable && /*#__PURE__*/_react.default.createElement(_aggregation_not_supported.AggregationNotSupported, {
    dataStream: dataStream
  }), /*#__PURE__*/_react.default.createElement(OverviewHeader, {
    handleRefresh: handleRefresh
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !dataStreamSettingsLoading && !hasFailureStore && canUserReadFailureStore && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginBottom: 16
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.datasetQuality.noFailureStoreTitle', {
      defaultMessage: 'Failure store is not enabled for this data stream. '
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl(locatorParams),
      target: "_blank",
      external: false,
      css: {
        textDecoration: 'underline'
      }
    }, _i18n.i18n.translate('xpack.datasetQuality.enableFailureStore', {
      defaultMessage: 'Enable failure store'
    })))
  })), !dataStreamSettingsLoading && !canUserReadFailureStore && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_failure_store_warning.FailureStoreWarning, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(Summary, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(DocumentTrends, {
    lastReloadTime: lastReloadTime
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_quality_issues.QualityIssues, null));
}