"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapSpatialFilter = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Use mapSpatialFilter mapper to avoid bloated meta with value and params for spatial filters.
const mapSpatialFilter = filter => {
  var _filter$meta;
  if (((_filter$meta = filter.meta) === null || _filter$meta === void 0 ? void 0 : _filter$meta.type) === _esQuery.FILTERS.SPATIAL_FILTER) {
    return {
      type: filter.meta.type,
      // spatial filters support multiple fields across multiple data views
      // do not provide "key" since filter does not provide a single field
      key: undefined,
      // default mapper puts stringified filter in "value"
      // do not provide "value" to avoid bloating URL
      value: undefined
    };
  }
  throw filter;
};
exports.mapSpatialFilter = mapSpatialFilter;