"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Groups = Groups;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _group = require("./group");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function Groups({
  groups
}) {
  return groups.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center",
    "data-test-subj": "dashboardPanelSelectionNoPanelMessage"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.solutionToolbar.addPanelFlyout.noResultsDescription",
    defaultMessage: "No panel types found"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "dashboardPanelSelectionList"
  }, groups.map(group => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: group.id,
    "data-test-subj": group['data-test-subj'],
    "data-group-sort-order": group.order
  }, /*#__PURE__*/_react.default.createElement(_group.Group, {
    group: group
  }))));
}