"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeSettingsManager = initializeSettingsManager;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _rxjs = require("rxjs");
var _default_dashboard_state = require("./default_dashboard_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// SERIALIZED STATE ONLY TODO: This could be simplified by using src/platform/packages/shared/presentation/presentation_publishing/state_manager/state_manager.ts
function initializeSettingsManager(initialState) {
  var _initialState$syncCol, _initialState$syncCur, _initialState$syncToo, _initialState$tags, _initialState$timeRes, _initialState$useMarg;
  const syncColors$ = new _rxjs.BehaviorSubject((_initialState$syncCol = initialState === null || initialState === void 0 ? void 0 : initialState.syncColors) !== null && _initialState$syncCol !== void 0 ? _initialState$syncCol : _default_dashboard_state.DEFAULT_DASHBOARD_STATE.syncColors);
  function setSyncColors(syncColors) {
    if (syncColors !== syncColors$.value) syncColors$.next(syncColors);
  }
  const syncCursor$ = new _rxjs.BehaviorSubject((_initialState$syncCur = initialState === null || initialState === void 0 ? void 0 : initialState.syncCursor) !== null && _initialState$syncCur !== void 0 ? _initialState$syncCur : _default_dashboard_state.DEFAULT_DASHBOARD_STATE.syncCursor);
  function setSyncCursor(syncCursor) {
    if (syncCursor !== syncCursor$.value) syncCursor$.next(syncCursor);
  }
  const syncTooltips$ = new _rxjs.BehaviorSubject((_initialState$syncToo = initialState === null || initialState === void 0 ? void 0 : initialState.syncTooltips) !== null && _initialState$syncToo !== void 0 ? _initialState$syncToo : _default_dashboard_state.DEFAULT_DASHBOARD_STATE.syncTooltips);
  function setSyncTooltips(syncTooltips) {
    if (syncTooltips !== syncTooltips$.value) syncTooltips$.next(syncTooltips);
  }
  const tags$ = new _rxjs.BehaviorSubject((_initialState$tags = initialState === null || initialState === void 0 ? void 0 : initialState.tags) !== null && _initialState$tags !== void 0 ? _initialState$tags : _default_dashboard_state.DEFAULT_DASHBOARD_STATE.tags);
  function setTags(tags) {
    if (!(0, _fastDeepEqual.default)(tags, tags$.value)) tags$.next(tags);
  }
  const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState !== null && initialState !== void 0 ? initialState : {});
  const timeRestore$ = new _rxjs.BehaviorSubject((_initialState$timeRes = initialState === null || initialState === void 0 ? void 0 : initialState.timeRestore) !== null && _initialState$timeRes !== void 0 ? _initialState$timeRes : _default_dashboard_state.DEFAULT_DASHBOARD_STATE.timeRestore);
  function setTimeRestore(timeRestore) {
    if (timeRestore !== timeRestore$.value) timeRestore$.next(timeRestore);
  }
  const useMargins$ = new _rxjs.BehaviorSubject((_initialState$useMarg = initialState === null || initialState === void 0 ? void 0 : initialState.useMargins) !== null && _initialState$useMarg !== void 0 ? _initialState$useMarg : _default_dashboard_state.DEFAULT_DASHBOARD_STATE.useMargins);
  function setUseMargins(useMargins) {
    if (useMargins !== useMargins$.value) useMargins$.next(useMargins);
  }
  function getSettings() {
    var _titleState$title, _titleState$hidePanel, _timeRestore$$value;
    const titleState = titleManager.getLatestState();
    return {
      title: (_titleState$title = titleState.title) !== null && _titleState$title !== void 0 ? _titleState$title : '',
      description: titleState.description,
      hidePanelTitles: (_titleState$hidePanel = titleState.hidePanelTitles) !== null && _titleState$hidePanel !== void 0 ? _titleState$hidePanel : _default_dashboard_state.DEFAULT_DASHBOARD_STATE.hidePanelTitles,
      syncColors: syncColors$.value,
      syncCursor: syncCursor$.value,
      syncTooltips: syncTooltips$.value,
      tags: tags$.value,
      timeRestore: (_timeRestore$$value = timeRestore$.value) !== null && _timeRestore$$value !== void 0 ? _timeRestore$$value : _default_dashboard_state.DEFAULT_DASHBOARD_STATE.timeRestore,
      useMargins: useMargins$.value
    };
  }
  function setSettings(settings) {
    setSyncColors(settings.syncColors);
    setSyncCursor(settings.syncCursor);
    setSyncTooltips(settings.syncTooltips);
    setTags(settings.tags);
    setTimeRestore(settings.timeRestore);
    setUseMargins(settings.useMargins);
    titleManager.api.setHideTitle(settings.hidePanelTitles);
    titleManager.api.setDescription(settings.description);
    titleManager.api.setTitle(settings.title);
  }
  const comparators = {
    title: _presentationPublishing.titleComparators.title,
    description: _presentationPublishing.titleComparators.description,
    hidePanelTitles: 'referenceEquality',
    syncColors: 'referenceEquality',
    syncCursor: 'referenceEquality',
    syncTooltips: 'referenceEquality',
    timeRestore: 'referenceEquality',
    useMargins: 'referenceEquality',
    tags: 'deepEquality'
  };
  return {
    api: {
      ...titleManager.api,
      getSettings,
      settings: {
        syncColors$,
        syncCursor$,
        syncTooltips$,
        useMargins$
      },
      setSettings,
      setTags,
      timeRestore$
    },
    internalApi: {
      startComparing$: lastSavedState$ => {
        return (0, _rxjs.combineLatest)([syncColors$, syncCursor$, syncTooltips$, tags$, timeRestore$, useMargins$, titleManager.anyStateChange$]).pipe((0, _rxjs.debounceTime)(100), (0, _rxjs.map)(() => getSettings()), (0, _rxjs.combineLatestWith)(lastSavedState$), (0, _rxjs.map)(([latestState, lastSavedState]) => (0, _presentationPublishing.diffComparators)(comparators, lastSavedState, latestState)));
      },
      reset: lastSavedState => {
        setSettings(lastSavedState);
      }
    }
  };
}