"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deserializeLayout = deserializeLayout;
var _uuid = require("uuid");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function deserializeLayout(panels, getReferences) {
  const layout = {
    panels: {},
    sections: {}
  };
  const childState = {};
  function pushPanel(panel, sectionId) {
    var _panel$panelIndex;
    const panelId = (_panel$panelIndex = panel.panelIndex) !== null && _panel$panelIndex !== void 0 ? _panel$panelIndex : (0, _uuid.v4)();
    layout.panels[panelId] = {
      type: panel.type,
      gridData: {
        ...panel.gridData,
        ...(sectionId && {
          sectionId
        }),
        i: panelId
      }
    };
    childState[panelId] = {
      rawState: {
        ...panel.panelConfig
      },
      references: getReferences(panelId)
    };
  }
  panels.forEach(widget => {
    if ((0, _common.isDashboardSection)(widget)) {
      var _widget$gridData$i;
      const sectionId = (_widget$gridData$i = widget.gridData.i) !== null && _widget$gridData$i !== void 0 ? _widget$gridData$i : (0, _uuid.v4)();
      const {
        panels: sectionPanels,
        ...restOfSection
      } = widget;
      layout.sections[sectionId] = {
        collapsed: false,
        ...restOfSection,
        gridData: {
          ...widget.gridData,
          i: sectionId
        }
      };
      sectionPanels.forEach(panel => {
        pushPanel(panel, sectionId);
      });
    } else {
      // if not a section, then this widget is a panel
      pushPanel(widget);
    }
  });
  return {
    layout,
    childState
  };
}