"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettingsConfig = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const deprecations = ({
  unused,
  renameFromRoot
}) => [unused('enabled', {
  level: 'warning'
}), renameFromRoot('server.defaultRoute', 'uiSettings.overrides.defaultRoute', {
  level: 'warning'
})];
const configSchema = _configSchema.schema.object({
  overrides: _configSchema.schema.object({}, {
    unknowns: 'allow'
  }),
  publicApiEnabled: (0, _configSchema.offeringBasedSchema)({
    serverless: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
});
const uiSettingsConfig = exports.uiSettingsConfig = {
  path: 'uiSettings',
  schema: configSchema,
  deprecations
};