"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Breadcrumbs = Breadcrumbs;
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function Breadcrumbs({
  breadcrumbs$
}) {
  const breadcrumbs = (0, _useObservable.default)(breadcrumbs$, []);
  let crumbs = breadcrumbs;
  if (breadcrumbs.length === 0) {
    crumbs = [{
      text: 'Kibana'
    }];
  }
  crumbs = crumbs.map((breadcrumb, i) => {
    const isLast = i === breadcrumbs.length - 1;
    const {
      deepLinkId,
      ...rest
    } = breadcrumb;
    return {
      ...rest,
      href: isLast ? undefined : breadcrumb.href,
      onClick: isLast ? undefined : breadcrumb.onClick,
      'data-test-subj': (0, _classnames.default)('breadcrumb', deepLinkId && `breadcrumb-deepLinkId-${deepLinkId}`, breadcrumb['data-test-subj'], i === 0 && 'first', isLast && 'last')
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBreadcrumbs, {
    breadcrumbs: crumbs,
    "data-test-subj": "breadcrumbs"
    // reduce number of visible breadcrumbs due to increased max-width of the root breadcrumbs
    ,
    responsive: {
      xs: 1,
      s: 2,
      m: 3,
      l: 4,
      xl: 7
    }
  });
}