"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateIndex = void 0;
var _migration_state_action_machine = require("./migration_state_action_machine");
var _context = require("./context");
var _next = require("./next");
var _model = require("./model");
var _state = require("./state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const migrateIndex = async ({
  logger,
  ...options
}) => {
  const context = (0, _context.createContext)(options);
  const initialState = (0, _state.createInitialState)(context);
  return (0, _migration_state_action_machine.migrationStateActionMachine)({
    initialState,
    next: (0, _next.next)(context),
    model: _model.model,
    context,
    logger
  });
};
exports.migrateIndex = migrateIndex;