"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavIconButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const NavIconButton = ({
  iconType,
  onClick,
  ariaLabel,
  dataTestSubj,
  toolTipContent
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: toolTipContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: iconType,
    onClick: onClick,
    "aria-label": ariaLabel,
    "data-test-subj": dataTestSubj
  }));
};
exports.NavIconButton = NavIconButton;