"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStatusCodeDecorations = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getStatusCodeClassName = statusCode => {
  if (statusCode <= 199) {
    return _constants.DEFAULT_STATUS_BADGE_CLASSNAME;
  }
  if (statusCode <= 299) {
    return _constants.SUCCESS_STATUS_BADGE_CLASSNAME;
  }
  if (statusCode <= 399) {
    return _constants.PRIMARY_STATUS_BADGE_CLASSNAME;
  }
  if (statusCode <= 499) {
    return _constants.WARNING_STATUS_BADGE_CLASSNAME;
  }
  return _constants.DANGER_STATUS_BADGE_CLASSNAME;
};
const getStatusCodeDecorations = data => {
  const decorations = [];
  let lastResponseEndLine = 0;
  data.forEach(({
    response
  }) => {
    if (response !== null && response !== void 0 && response.value) {
      const totalStatus = response.statusCode && response.statusText ? response.statusCode + ' ' + response.statusText : '';
      const startColumn = response.value.indexOf(totalStatus) + 1;
      if (totalStatus && startColumn !== 0) {
        const range = {
          startLineNumber: lastResponseEndLine + 1,
          startColumn,
          endLineNumber: lastResponseEndLine + 1,
          endColumn: startColumn + totalStatus.length
        };
        decorations.push({
          range,
          options: {
            inlineClassName: getStatusCodeClassName(response.statusCode)
          }
        });
      }
      lastResponseEndLine += response.value.split(/\\n|\n/).length;
    }
  });
  return decorations;
};
exports.getStatusCodeDecorations = getStatusCodeDecorations;