"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineFindCspBenchmarkRuleRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _latest = require("@kbn/cloud-security-posture-common/schema/rules/latest");
var _v = require("@kbn/cloud-security-posture-common/schema/rules/v3");
var _v2 = require("@kbn/cloud-security-posture-common/schema/rules/v4");
var _constants = require("../../../../common/constants");
var _v3 = require("./v1");
var _v4 = require("./v2");
var _v5 = require("./v3");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defineFindCspBenchmarkRuleRoute = router => router.versioned.get({
  access: 'internal',
  path: _constants.FIND_CSP_BENCHMARK_RULE_ROUTE_PATH,
  security: {
    authz: {
      requiredPrivileges: ['cloud-security-posture-read']
    }
  }
}).addVersion({
  version: '1',
  validate: {
    request: {
      query: _v.findCspBenchmarkRuleRequestSchema
    }
  }
}, async (context, request, response) => {
  const requestBody = request.query;
  const cspContext = await context.csp;
  try {
    const cspBenchmarkRules = await (0, _v3.findBenchmarkRuleHandler)(cspContext.soClient, requestBody);
    return response.ok({
      body: cspBenchmarkRules
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cspContext.logger.error(`Failed to fetch csp rules templates ${err}`);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
}).addVersion({
  version: '2',
  validate: {
    request: {
      query: _v2.findCspBenchmarkRuleRequestSchema
    }
  }
}, async (context, request, response) => {
  const requestBody = request.query;
  const cspContext = await context.csp;
  try {
    const cspBenchmarkRules = await (0, _v4.findBenchmarkRuleHandler)(cspContext.soClient, requestBody);
    return response.ok({
      body: cspBenchmarkRules
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cspContext.logger.error(`Failed to fetch csp rules templates ${err}`);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
}).addVersion({
  version: '3',
  validate: {
    request: {
      query: _latest.findCspBenchmarkRuleRequestSchema
    }
  }
}, async (context, request, response) => {
  const requestBody = request.query;
  const cspContext = await context.csp;
  try {
    const cspBenchmarkRules = await (0, _v5.findBenchmarkRuleHandler)(cspContext.soClient, requestBody);
    return response.ok({
      body: cspBenchmarkRules
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cspContext.logger.error(`Failed to fetch csp rules templates ${err}`);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
});
exports.defineFindCspBenchmarkRuleRoute = defineFindCspBenchmarkRuleRoute;