"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGroupedVulnerabilities = exports.getGroupedVulnerabilitiesQuery = void 0;
var _reactQuery = require("@kbn/react-query");
var _rxjs = require("rxjs");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _use_kibana = require("../../../common/hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Elasticsearch returns `null` when a sub-aggregation cannot be computed

const getGroupedVulnerabilitiesQuery = query => ({
  ...query,
  index: _cloudSecurityPostureCommon.CDR_VULNERABILITIES_INDEX_PATTERN,
  ignore_unavailable: true,
  size: 0
});
exports.getGroupedVulnerabilitiesQuery = getGroupedVulnerabilitiesQuery;
const useGroupedVulnerabilities = ({
  query,
  enabled = true
}) => {
  const {
    data,
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)(['csp_grouped_vulnerabilities', {
    query
  }], async () => {
    const {
      rawResponse: {
        aggregations
      }
    } = await (0, _rxjs.lastValueFrom)(data.search.search({
      params: getGroupedVulnerabilitiesQuery(query)
    }));
    if (!aggregations) throw new Error('Failed to aggregate by, missing resource id');
    return aggregations;
  }, {
    onError: err => (0, _cloudSecurityPosture.showErrorToast)(toasts, err),
    enabled,
    // This allows the UI to keep the previous data while the new data is being fetched
    keepPreviousData: true
  });
};
exports.useGroupedVulnerabilities = useGroupedVulnerabilities;