"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleNameLink = exports.FindingsRuleFlyout = exports.EMPTY_VALUE = exports.CspFlyoutMarkdown = exports.CodeBlock = exports.BenchmarkIcons = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _std = require("@kbn/std");
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _get_vendor_name = require("@kbn/cloud-security-posture/src/utils/get_vendor_name");
var _helpers = require("../../../../common/utils/helpers");
var _constants = require("../../../common/navigation/constants");
var _cis_logo = _interopRequireDefault(require("../../../assets/icons/cis_logo.svg"));
var _take_action = require("../../../components/take_action");
var _table_tab = require("./table_tab");
var _json_tab = require("./json_tab");
var _overview_tab = require("./overview_tab");
var _rule_tab = require("./rule_tab");
var _cis_benchmark_icon = require("../../../components/cis_benchmark_icon");
var _test_subjects = require("../test_subjects");
var _use_kibana = require("../../../common/hooks/use_kibana");
var _create_detection_rule_from_benchmark = require("../utils/create_detection_rule_from_benchmark");
var _csp_inline_description_list = require("../../../components/csp_inline_description_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tabs = [{
  id: 'overview',
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTabTitle', {
    defaultMessage: 'Overview'
  })
}, {
  id: 'rule',
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTabTitle', {
    defaultMessage: 'Rule'
  })
}, {
  id: 'table',
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.tableTabTitle', {
    defaultMessage: 'Table'
  })
}, {
  id: 'json',
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.jsonTabTitle', {
    defaultMessage: 'JSON'
  })
}];
const PAGINATION_LABEL = _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.paginationLabel', {
  defaultMessage: 'Finding navigation'
});
const EMPTY_VALUE = exports.EMPTY_VALUE = '-';
const CodeBlock = props => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, (0, _extends2.default)({
  isCopyable: true,
  paddingSize: "s",
  overflowHeight: 300
}, props));
exports.CodeBlock = CodeBlock;
const CspFlyoutMarkdown = props => /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, (0, _extends2.default)({
  textSize: "s"
}, props));
exports.CspFlyoutMarkdown = CspFlyoutMarkdown;
const BenchmarkIcons = ({
  benchmarkId,
  benchmarkName
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  alignItems: "center"
}, benchmarkId.startsWith('cis') && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: "Center for Internet Security"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: _cis_logo.default,
  size: "xl"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
  type: benchmarkId,
  name: benchmarkName
})));
exports.BenchmarkIcons = BenchmarkIcons;
const RuleNameLink = ({
  ruleFlyoutLink,
  ruleName
}) => {
  return ruleFlyoutLink && ruleName ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleNameTabField.ruleNameTooltip', {
      defaultMessage: 'Manage Rule'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: ruleFlyoutLink
  }, ruleName)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ruleName);
};
exports.RuleNameLink = RuleNameLink;
const getFlyoutDescriptionList = finding => {
  var _finding$resource, _finding$resource2;
  return [((_finding$resource = finding.resource) === null || _finding$resource === void 0 ? void 0 : _finding$resource.id) && {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.flyoutDescriptionList.resourceId', {
      defaultMessage: 'Resource ID'
    }),
    description: finding.resource.id
  }, ((_finding$resource2 = finding.resource) === null || _finding$resource2 === void 0 ? void 0 : _finding$resource2.name) && {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.flyoutDescriptionList.resourceName', {
      defaultMessage: 'Resource Name'
    }),
    description: finding.resource.name
  }].filter(_helpers.truthy);
};
const FindingsTab = ({
  tab,
  finding
}) => {
  var _finding$rule, _finding$rule$benchma, _finding$rule2, _finding$rule2$benchm, _finding$rule3;
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  const ruleFlyoutLink =
  // currently we only support rule linking for native CSP findings
  finding.data_stream.dataset === _get_vendor_name.CSP_MISCONFIGURATIONS_DATASET && (_finding$rule = finding.rule) !== null && _finding$rule !== void 0 && (_finding$rule$benchma = _finding$rule.benchmark) !== null && _finding$rule$benchma !== void 0 && _finding$rule$benchma.version && (_finding$rule2 = finding.rule) !== null && _finding$rule2 !== void 0 && (_finding$rule2$benchm = _finding$rule2.benchmark) !== null && _finding$rule2$benchm !== void 0 && _finding$rule2$benchm.id && (_finding$rule3 = finding.rule) !== null && _finding$rule3 !== void 0 && _finding$rule3.id ? application.getUrlForApp('security', {
    path: (0, _reactRouterDom.generatePath)(_constants.benchmarksNavigation.rules.path, {
      benchmarkVersion: finding.rule.benchmark.version.split('v')[1],
      // removing the v from the version
      benchmarkId: finding.rule.benchmark.id,
      ruleId: finding.rule.id
    })
  }) : undefined;
  switch (tab.id) {
    case 'overview':
      return /*#__PURE__*/_react.default.createElement(_overview_tab.OverviewTab, {
        data: finding,
        ruleFlyoutLink: ruleFlyoutLink
      });
    case 'rule':
      return /*#__PURE__*/_react.default.createElement(_rule_tab.RuleTab, {
        data: finding,
        ruleFlyoutLink: ruleFlyoutLink
      });
    case 'table':
      return /*#__PURE__*/_react.default.createElement(_table_tab.TableTab, {
        data: finding
      });
    case 'json':
      return /*#__PURE__*/_react.default.createElement(_json_tab.JsonTab, {
        data: finding
      });
    default:
      (0, _std.assertNever)(tab);
  }
};
const FindingsRuleFlyout = ({
  onClose,
  finding,
  flyoutIndex,
  findingsCount,
  onPaginate
}) => {
  var _finding$result, _finding$rule4, _finding$rule5;
  const [tab, setTab] = (0, _react.useState)(tabs[0]);
  const createMisconfigurationRuleFn = async http => await (0, _create_detection_rule_from_benchmark.createDetectionRuleFromBenchmarkRule)(http, finding.rule);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": _test_subjects.FINDINGS_FLYOUT
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.CspEvaluationBadge, {
    type: (_finding$result = finding.result) === null || _finding$result === void 0 ? void 0 : _finding$result.evaluation
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      minWidth: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "primary",
    title: (_finding$rule4 = finding.rule) === null || _finding$rule4 === void 0 ? void 0 : _finding$rule4.name
  }, (_finding$rule5 = finding.rule) === null || _finding$rule5 === void 0 ? void 0 : _finding$rule5.name)))), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
            line-height: 20px;
            margin-top: ${_uiTheme.euiThemeVars.euiSizeM};
          `
  }, /*#__PURE__*/_react.default.createElement(_csp_inline_description_list.CspInlineDescriptionList, {
    testId: _test_subjects.FINDINGS_MISCONFIGS_FLYOUT_DESCRIPTION_LIST,
    listItems: getFlyoutDescriptionList(finding)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, tabs.map(v => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: v.id,
    isSelected: tab.id === v.id,
    onClick: () => setTab(v),
    "data-test-subj": `findings_flyout_tab_${v.id}`
  }, v.title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    key: tab.id
  }, /*#__PURE__*/_react.default.createElement(FindingsTab, {
    tab: tab,
    finding: finding
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    justifyContent: onPaginate ? 'spaceBetween' : 'flexEnd'
  }, onPaginate && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": PAGINATION_LABEL,
    pageCount: findingsCount,
    activePage: flyoutIndex,
    onPageClick: onPaginate,
    compressed: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_take_action.TakeAction, {
    createRuleFn: createMisconfigurationRuleFn
  })))));
};
exports.FindingsRuleFlyout = FindingsRuleFlyout;