"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HoverableUserWithAvatar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _user_tooltip = require("./user_tooltip");
var _small_user_avatar = require("./small_user_avatar");
var _username = require("./username");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HoverableUserWithAvatarComponent = ({
  userInfo,
  boldName
}) => {
  return /*#__PURE__*/_react.default.createElement(_user_tooltip.UserToolTip, {
    userInfo: userInfo
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_small_user_avatar.SmallUserAvatar, {
    userInfo: userInfo
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column',
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_username.Username, {
    userInfo: userInfo,
    boldName: boldName
  }))))));
};
HoverableUserWithAvatarComponent.displayName = 'HoverableUserWithAvatar';
const HoverableUserWithAvatar = exports.HoverableUserWithAvatar = /*#__PURE__*/_react.default.memo(HoverableUserWithAvatarComponent);