"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSeverityUserActionBuilder = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _translations = require("../create/translations");
var _common = require("./common");
var _config = require("../severity/config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLabelTitle = userAction => {
  const severity = userAction.payload.severity;
  const severityData = _config.severities[severity];
  if (severityData === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    "data-test-subj": `${userAction.id}-user-action-severity-title`,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _translations.SET_SEVERITY_TO), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `${userAction.id}-user-action-severity-title-${severity}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: severityData.color
  }, severityData.label)));
};
const createSeverityUserActionBuilder = ({
  userAction,
  userProfiles,
  handleOutlineComment
}) => ({
  build: () => {
    const severityUserAction = userAction;
    const label = getLabelTitle(severityUserAction);
    const commonBuilder = (0, _common.createCommonUpdateUserActionBuilder)({
      userProfiles,
      userAction,
      handleOutlineComment,
      label,
      icon: 'dot'
    });
    return commonBuilder.build();
  }
});
exports.createSeverityUserActionBuilder = createSeverityUserActionBuilder;