"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToasts = exports.useTimeZone = exports.useNavigation = exports.useNavigateTo = exports.useHttp = exports.useDateFormat = exports.useCurrentUser = exports.useApplicationCapabilities = exports.useAppUrl = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _capabilities = require("../../../client/helpers/capabilities");
var _utils = require("../../../api/utils");
var _constants = require("../../../../common/constants");
var _kibana_react = require("./kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDateFormat = () => (0, _kibana_react.useUiSetting)(_constants.DEFAULT_DATE_FORMAT);
exports.useDateFormat = useDateFormat;
const useTimeZone = () => {
  const timeZone = (0, _kibana_react.useUiSetting)(_constants.DEFAULT_DATE_FORMAT_TZ);
  return timeZone === 'Browser' ? _momentTimezone.default.tz.guess() : timeZone;
};
exports.useTimeZone = useTimeZone;
const useToasts = () => (0, _kibana_react.useKibana)().services.notifications.toasts;
exports.useToasts = useToasts;
const useHttp = () => (0, _kibana_react.useKibana)().services.http;
exports.useHttp = useHttp;
const useCurrentUser = () => {
  const [user, setUser] = (0, _react.useState)(null);
  const toasts = useToasts();
  const {
    security
  } = (0, _kibana_react.useKibana)().services;
  const fetchUser = (0, _react.useCallback)(() => {
    let didCancel = false;
    const fetchData = async () => {
      try {
        if (security != null) {
          const response = await security.authc.getCurrentUser();
          if (!didCancel) {
            setUser((0, _utils.convertToCamelCase)(response));
          }
        } else {
          setUser({
            username: _i18n.i18n.translate('xpack.cases.getCurrentUser.unknownUser', {
              defaultMessage: 'Unknown'
            }),
            email: '',
            fullName: '',
            roles: [],
            enabled: false,
            authenticationRealm: {
              name: '',
              type: ''
            },
            lookupRealm: {
              name: '',
              type: ''
            },
            authenticationProvider: ''
          });
        }
      } catch (error) {
        if (!didCancel) {
          toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
            title: _i18n.i18n.translate('xpack.cases.getCurrentUser.Error', {
              defaultMessage: 'Error getting user'
            })
          });
          setUser(null);
        }
      }
    };
    fetchData();
    return () => {
      didCancel = true;
    };
  }, [security, toasts]);
  (0, _react.useEffect)(() => {
    fetchUser();
  }, [fetchUser]);
  return user;
};

/**
 * Returns a full URL to the provided page path by using
 * kibana's `getUrlForApp()`
 */
exports.useCurrentUser = useCurrentUser;
const useAppUrl = appId => {
  const {
    getUrlForApp
  } = (0, _kibana_react.useKibana)().services.application;
  const getAppUrl = (0, _react.useCallback)(options => getUrlForApp(appId !== null && appId !== void 0 ? appId : '', options), [appId, getUrlForApp]);
  return {
    getAppUrl
  };
};

/**
 * Navigate to any app using kibana's `navigateToApp()`
 * or by url using `navigateToUrl()`
 */
exports.useAppUrl = useAppUrl;
const useNavigateTo = appId => {
  const {
    navigateToApp,
    navigateToUrl
  } = (0, _kibana_react.useKibana)().services.application;
  const navigateTo = (0, _react.useCallback)(({
    url,
    ...options
  }) => {
    if (url) {
      navigateToUrl(url);
    } else {
      navigateToApp(appId !== null && appId !== void 0 ? appId : '', options);
    }
  }, [appId, navigateToApp, navigateToUrl]);
  return {
    navigateTo
  };
};

/**
 * Returns navigateTo and getAppUrl navigation hooks
 *
 */
exports.useNavigateTo = useNavigateTo;
const useNavigation = appId => {
  const {
    navigateTo
  } = useNavigateTo(appId);
  const {
    getAppUrl
  } = useAppUrl(appId);
  return {
    navigateTo,
    getAppUrl
  };
};
exports.useNavigation = useNavigation;
/**
 * Returns the capabilities of various applications
 *
 */

const useApplicationCapabilities = () => {
  var _useKibana$services, _useKibana$services$a, _capabilities$actions3, _capabilities$actions4, _capabilities$dashboa3, _capabilities$dashboa4, _capabilities$visuali3, _capabilities$visuali4;
  const capabilities = (_useKibana$services = (0, _kibana_react.useKibana)().services) === null || _useKibana$services === void 0 ? void 0 : (_useKibana$services$a = _useKibana$services.application) === null || _useKibana$services$a === void 0 ? void 0 : _useKibana$services$a.capabilities;
  const casesCapabilities = capabilities[_constants.FEATURE_ID_V3];
  const permissions = (0, _capabilities.getUICapabilities)(casesCapabilities);
  return (0, _react.useMemo)(() => {
    var _capabilities$actions, _capabilities$actions2, _capabilities$visuali, _capabilities$visuali2, _capabilities$dashboa, _capabilities$dashboa2;
    return {
      actions: {
        crud: !!((_capabilities$actions = capabilities.actions) !== null && _capabilities$actions !== void 0 && _capabilities$actions.save),
        read: !!((_capabilities$actions2 = capabilities.actions) !== null && _capabilities$actions2 !== void 0 && _capabilities$actions2.show)
      },
      generalCasesV3: {
        all: permissions.all,
        create: permissions.create,
        read: permissions.read,
        update: permissions.update,
        delete: permissions.delete,
        push: permissions.push,
        connectors: permissions.connectors,
        settings: permissions.settings,
        reopenCase: permissions.reopenCase,
        createComment: permissions.createComment,
        assign: permissions.assign
      },
      visualize: {
        crud: !!((_capabilities$visuali = capabilities.visualize) !== null && _capabilities$visuali !== void 0 && _capabilities$visuali.save),
        read: !!((_capabilities$visuali2 = capabilities.visualize) !== null && _capabilities$visuali2 !== void 0 && _capabilities$visuali2.show)
      },
      dashboard: {
        crud: !!((_capabilities$dashboa = capabilities.dashboard) !== null && _capabilities$dashboa !== void 0 && _capabilities$dashboa.createNew),
        read: !!((_capabilities$dashboa2 = capabilities.dashboard) !== null && _capabilities$dashboa2 !== void 0 && _capabilities$dashboa2.show)
      }
    };
  }, [(_capabilities$actions3 = capabilities.actions) === null || _capabilities$actions3 === void 0 ? void 0 : _capabilities$actions3.save, (_capabilities$actions4 = capabilities.actions) === null || _capabilities$actions4 === void 0 ? void 0 : _capabilities$actions4.show, (_capabilities$dashboa3 = capabilities.dashboard) === null || _capabilities$dashboa3 === void 0 ? void 0 : _capabilities$dashboa3.createNew, (_capabilities$dashboa4 = capabilities.dashboard) === null || _capabilities$dashboa4 === void 0 ? void 0 : _capabilities$dashboa4.show, (_capabilities$visuali3 = capabilities.visualize) === null || _capabilities$visuali3 === void 0 ? void 0 : _capabilities$visuali3.save, (_capabilities$visuali4 = capabilities.visualize) === null || _capabilities$visuali4 === void 0 ? void 0 : _capabilities$visuali4.show, permissions.all, permissions.create, permissions.read, permissions.update, permissions.delete, permissions.push, permissions.connectors, permissions.settings, permissions.reopenCase, permissions.createComment, permissions.assign]);
};
exports.useApplicationCapabilities = useApplicationCapabilities;