"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadImport = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../i18n/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkpadImport = ({
  uniqueKey,
  canUserWrite,
  onImportWorkpad = () => {}
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
  display: "default",
  className: "canvasWorkpad__upload--compressed",
  "aria-label": strings.getFilePickerPlaceholder(),
  initialPromptText: strings.getFilePickerPlaceholder(),
  onChange: onImportWorkpad,
  key: uniqueKey,
  accept: "application/json",
  disabled: !canUserWrite
});
exports.WorkpadImport = WorkpadImport;
const strings = {
  getFilePickerPlaceholder: () => _i18n.i18n.translate('xpack.canvas.workpadImport.filePickerPlaceholder', {
    defaultMessage: 'Import workpad {JSON} file',
    values: {
      JSON: _constants.JSON
    }
  })
};