"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESFieldSelect = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESFieldSelect = ({
  value,
  fields = [],
  onChange,
  onFocus,
  onBlur
}) => {
  const selectedOption = value ? [{
    label: value
  }] : [];
  const options = fields.map(field => ({
    label: field
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    selectedOptions: selectedOption,
    options: options,
    onChange: ([field]) => {
      var _field$label;
      return onChange((_field$label = field === null || field === void 0 ? void 0 : field.label) !== null && _field$label !== void 0 ? _field$label : null);
    },
    onSearchChange: searchValue => {
      // resets input when user starts typing
      if (searchValue) {
        onChange(null);
      }
    },
    onFocus: onFocus,
    onBlur: onBlur,
    singleSelection: {
      asPlainText: true
    },
    isClearable: false,
    compressed: true
  });
};
exports.ESFieldSelect = ESFieldSelect;