"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESDataViewSelect = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultIndex = '_all';
const defaultOption = {
  value: defaultIndex,
  label: defaultIndex
};
const ESDataViewSelect = ({
  value = defaultIndex,
  loading,
  dataViews,
  onChange,
  onFocus,
  onBlur
}) => {
  const selectedDataView = dataViews.find(view => value === view.title);
  const selectedOption = selectedDataView ? {
    value: selectedDataView.title,
    label: selectedDataView.name || selectedDataView.title
  } : {
    value,
    label: value
  };
  const options = dataViews.map(({
    name,
    title
  }) => ({
    value: title,
    label: name || title,
    'data-test-subj': `canvasDataViewSelect__${name || title}`
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    selectedOptions: [selectedOption],
    onChange: ([view]) => {
      onChange(view.value || defaultOption.value);
    },
    onSearchChange: searchValue => {
      // resets input when user starts typing
      if (searchValue) {
        onChange(defaultOption.value);
      }
    },
    onBlur: onBlur,
    onFocus: onFocus,
    isDisabled: loading,
    options: options,
    singleSelection: {
      asPlainText: true
    },
    isClearable: false,
    onCreateOption: input => onChange(input || defaultOption.value),
    compressed: true,
    "data-test-subj": "canvasDataViewSelect"
  });
};
exports.ESDataViewSelect = ESDataViewSelect;