"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createApmSourceMap = createApmSourceMap;
var _apm_system_index_constants = require("../settings/apm_indices/apm_system_index_constants");
var _sourcemap_utils = require("./sourcemap_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createApmSourceMap({
  internalESClient,
  logger,
  fleetId,
  created,
  sourceMapContent,
  bundleFilepath,
  serviceName,
  serviceVersion
}) {
  const {
    contentEncoded,
    contentHash
  } = await (0, _sourcemap_utils.getEncodedContent)(sourceMapContent);
  const doc = {
    fleet_id: fleetId,
    created,
    content: contentEncoded,
    content_sha256: contentHash,
    file: {
      path: bundleFilepath
    },
    service: {
      name: serviceName,
      version: serviceVersion
    }
  };
  const id = (0, _sourcemap_utils.getSourceMapId)({
    serviceName,
    serviceVersion,
    bundleFilepath
  });
  logger.debug(`Create APM source map: "${id}"`);
  return await internalESClient.index({
    index: _apm_system_index_constants.APM_SOURCE_MAP_INDEX,
    id,
    body: doc
  });
}