"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGetApmDownstreamDependenciesFunction = registerGetApmDownstreamDependenciesFunction;
var _i18n = require("@kbn/i18n");
var _get_apm_downstream_dependencies = require("../routes/assistant_functions/get_apm_downstream_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerGetApmDownstreamDependenciesFunction({
  apmEventClient,
  registerFunction,
  randomSampler
}) {
  registerFunction({
    name: 'get_apm_downstream_dependencies',
    description: `Get the downstream dependencies (services or uninstrumented backends) for a
      service. This allows you to map the downstream dependency name to a service, by
      returning both span.destination.service.resource and service.name. Use this to
      drilldown further if needed.`,
    descriptionForUser: _i18n.i18n.translate('xpack.apm.observabilityAiAssistant.functions.registerGetApmDownstreamDependencies.descriptionForUser', {
      defaultMessage: `Get the downstream dependencies (services or uninstrumented backends) for a
      service. This allows you to map the dowstream dependency name to a service, by
      returning both span.destination.service.resource and service.name. Use this to
      drilldown further if needed.`
    }),
    parameters: {
      type: 'object',
      properties: {
        serviceName: {
          type: 'string',
          description: 'The name of the service'
        },
        serviceEnvironment: {
          type: 'string',
          description: 'The environment that the service is running in. Leave empty to query for all environments.'
        },
        start: {
          type: 'string',
          description: 'The start of the time range, in Elasticsearch date math, like `now`.'
        },
        end: {
          type: 'string',
          description: 'The end of the time range, in Elasticsearch date math, like `now-24h`.'
        }
      },
      required: ['serviceName', 'start', 'end']
    }
  }, async ({
    arguments: args
  }, signal) => {
    return {
      content: {
        dependencies: await (0, _get_apm_downstream_dependencies.getAssistantDownstreamDependencies)({
          arguments: args,
          apmEventClient,
          randomSampler
        })
      }
    };
  });
}