"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionSummary = TransactionSummary;
var _react = _interopRequireDefault(require("react"));
var _ = require(".");
var _timestamp_tooltip = require("../timestamp_tooltip");
var _duration_summary_item = require("./duration_summary_item");
var _error_count_summary_item_badge = require("./error_count_summary_item_badge");
var _http_info_summary_item = require("./http_info_summary_item");
var _transaction_result_summary_item = require("./transaction_result_summary_item");
var _user_agent_summary_item = require("./user_agent_summary_item");
var _cold_start_badge = require("../../app/transaction_details/waterfall_with_summary/waterfall_container/waterfall/badge/cold_start_badge");
var _build_url = require("../../../utils/build_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTransactionResultSummaryItem(transaction) {
  var _transaction$url, _transaction$transact, _transaction$transact2;
  const result = transaction.transaction.result;
  const urlFull = ((_transaction$url = transaction.url) === null || _transaction$url === void 0 ? void 0 : _transaction$url.full) || ((_transaction$transact = transaction.transaction) === null || _transaction$transact === void 0 ? void 0 : (_transaction$transact2 = _transaction$transact.page) === null || _transaction$transact2 === void 0 ? void 0 : _transaction$transact2.url);
  const url = urlFull !== null && urlFull !== void 0 ? urlFull : (0, _build_url.buildUrl)(transaction);
  if (url) {
    var _transaction$http, _transaction$http$req, _transaction$http2, _transaction$http2$re;
    const method = (_transaction$http = transaction.http) === null || _transaction$http === void 0 ? void 0 : (_transaction$http$req = _transaction$http.request) === null || _transaction$http$req === void 0 ? void 0 : _transaction$http$req.method;
    const status = (_transaction$http2 = transaction.http) === null || _transaction$http2 === void 0 ? void 0 : (_transaction$http2$re = _transaction$http2.response) === null || _transaction$http2$re === void 0 ? void 0 : _transaction$http2$re.status_code;
    return /*#__PURE__*/_react.default.createElement(_http_info_summary_item.HttpInfoSummaryItem, {
      method: method,
      status: status,
      url: url
    });
  }
  if (result) {
    return /*#__PURE__*/_react.default.createElement(_transaction_result_summary_item.TransactionResultSummaryItem, {
      transactionResult: result
    });
  }
  return null;
}
function TransactionSummary({
  transaction,
  totalDuration,
  errorCount,
  coldStartBadge
}) {
  const items = [/*#__PURE__*/_react.default.createElement(_timestamp_tooltip.TimestampTooltip, {
    time: transaction.timestamp.us / 1000
  }), /*#__PURE__*/_react.default.createElement(_duration_summary_item.DurationSummaryItem, {
    duration: transaction.transaction.duration.us,
    totalDuration: totalDuration,
    parentType: "trace"
  }), getTransactionResultSummaryItem(transaction), errorCount ? /*#__PURE__*/_react.default.createElement(_error_count_summary_item_badge.ErrorCountSummaryItemBadge, {
    count: errorCount
  }) : null, transaction.user_agent ? /*#__PURE__*/_react.default.createElement(_user_agent_summary_item.UserAgentSummaryItem, transaction.user_agent) : null, coldStartBadge ? /*#__PURE__*/_react.default.createElement(_cold_start_badge.ColdStartBadge, null) : null];
  return /*#__PURE__*/_react.default.createElement(_.Summary, {
    items: items
  });
}