"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionDetailLink = TransactionDetailLink;
exports.txGroupsDroppedBucketName = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _style = require("../../../../../utils/style");
var _popover_tooltip = require("../../../popover_tooltip");
var _truncate_with_tooltip = require("../../../truncate_with_tooltip");
var _max_groups_message = require("../max_groups_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const txGroupsDroppedBucketName = exports.txGroupsDroppedBucketName = '_other';
function TransactionDetailLink({
  transactionName,
  href,
  ...rest
}) {
  if (transactionName !== txGroupsDroppedBucketName) {
    return /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
      text: transactionName,
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
        "data-test-subj": "apmTransactionDetailLinkLink",
        href: href
      }, rest))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      fontStyle: 'italic'
    }
  }, _i18n.i18n.translate('xpack.apm.transactionDetail.remainingServices', {
    defaultMessage: 'Remaining Transactions'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_popover_tooltip.PopoverTooltip, {
    ariaLabel: _i18n.i18n.translate('xpack.apm.transactionDetail.tooltip', {
      defaultMessage: 'Max transaction groups reached tooltip'
    }),
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      width: `${_style.unit * 28}px`
    },
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_max_groups_message.MaxGroupsMessage, null)))));
}