"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CriticalPathFlamegraphTooltip = CriticalPathFlamegraphTooltip;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _i18n = require("@kbn/i18n");
var _customIcons = require("@kbn/custom-icons");
var _apm = require("../../../../common/es_fields/apm");
var _span_icon = require("../span_icon");
var _formatters = require("../../../../common/utils/formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CriticalPathFlamegraphTooltip({
  metadata,
  countInclusive,
  countExclusive,
  totalCount
}) {
  if (!metadata) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, metadata['processor.event'] === _common.ProcessorEvent.transaction ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    style: {
      overflowWrap: 'anywhere'
    },
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, metadata[_apm.TRANSACTION_NAME]), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, metadata[_apm.TRANSACTION_TYPE])))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    style: {
      overflowWrap: 'anywhere'
    },
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_span_icon.SpanIcon, {
    type: metadata[_apm.SPAN_TYPE],
    subtype: metadata[_apm.SPAN_SUBTYPE],
    role: "presentation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, metadata[_apm.SPAN_NAME]))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_customIcons.AgentIcon, {
    agentName: metadata[_apm.AGENT_NAME],
    size: "l",
    role: "presentation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, metadata[_apm.SERVICE_NAME]))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _i18n.i18n.translate('xpack.apm.criticalPathFlameGraph.selfTime', {
    defaultMessage: 'Self time: {value}',
    values: {
      value: (0, _formatters.asPercent)(countExclusive / totalCount, 1)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _i18n.i18n.translate('xpack.apm.criticalPathFlameGraph.totalTime', {
    defaultMessage: 'Total time: {value}',
    values: {
      value: (0, _formatters.asPercent)(countInclusive / totalCount, 1)
    }
  }))))));
}