"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.maybeRedirectToAvailableSpanSample = maybeRedirectToAvailableSpanSample;
var _use_fetcher = require("../../../hooks/use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function maybeRedirectToAvailableSpanSample({
  spanFetchStatus,
  spanId,
  pageSize,
  page,
  replace,
  samples,
  history
}) {
  var _samples$find, _samples$, _samples$findIndex;
  if (spanFetchStatus !== _use_fetcher.FETCH_STATUS.SUCCESS) {
    // we're still loading, don't do anything
    return;
  }
  const nextSpanId = ((_samples$find = samples.find(sample => sample.spanId === spanId)) === null || _samples$find === void 0 ? void 0 : _samples$find.spanId) || ((_samples$ = samples[0]) === null || _samples$ === void 0 ? void 0 : _samples$.spanId) || '';
  const indexOfNextSample = (_samples$findIndex = samples.findIndex(sample => sample.spanId === nextSpanId)) !== null && _samples$findIndex !== void 0 ? _samples$findIndex : 0;
  const nextPageIndex = Math.floor((indexOfNextSample + 1) / (pageSize !== null && pageSize !== void 0 ? pageSize : 10));
  if (page !== nextPageIndex || (spanId !== null && spanId !== void 0 ? spanId : '') !== nextSpanId) {
    replace(history, {
      query: {
        spanId: nextSpanId,
        page: nextPageIndex.toString()
      }
    });
  }
}