"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rawRulesSettingsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rawRulesSettingsSchema = exports.rawRulesSettingsSchema = _configSchema.schema.object({
  flapping: _configSchema.schema.maybe(_configSchema.schema.object({
    createdAt: _configSchema.schema.string(),
    createdBy: _configSchema.schema.nullable(_configSchema.schema.string()),
    enabled: _configSchema.schema.boolean(),
    lookBackWindow: _configSchema.schema.number(),
    statusChangeThreshold: _configSchema.schema.number(),
    updatedAt: _configSchema.schema.string(),
    updatedBy: _configSchema.schema.nullable(_configSchema.schema.string())
  })),
  queryDelay: _configSchema.schema.maybe(_configSchema.schema.object({
    createdAt: _configSchema.schema.string(),
    createdBy: _configSchema.schema.nullable(_configSchema.schema.string()),
    delay: _configSchema.schema.number(),
    updatedAt: _configSchema.schema.string(),
    updatedBy: _configSchema.schema.nullable(_configSchema.schema.string())
  }))
});