"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBackfillError = createBackfillError;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createBackfillError(message, ruleId, ruleName) {
  return {
    error: {
      message,
      rule: {
        id: ruleId,
        ...(ruleName ? {
          name: ruleName
        } : {})
      }
    }
  };
}