"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteMaintenanceWindow = deleteMaintenanceWindow;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _schemas = require("./schemas");
var _retry_if_conflicts = require("../../../../lib/retry_if_conflicts");
var _maintenance_window = require("../../../../data/maintenance_window");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteMaintenanceWindow(context, params) {
  return await (0, _retry_if_conflicts.retryIfConflicts)(context.logger, `maintenanceWindowClient.delete('${params.id}')`, async () => await deleteWithOCC(context, params));
}
async function deleteWithOCC(context, params) {
  const {
    savedObjectsClient,
    logger
  } = context;
  const {
    id
  } = params;
  try {
    _schemas.deleteMaintenanceWindowParamsSchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Error validating delete maintenance window data - ${error.message}`);
  }
  try {
    return await (0, _maintenance_window.deleteMaintenanceWindowSo)({
      id,
      savedObjectsClient
    });
  } catch (e) {
    const errorMessage = `Failed to delete maintenance window by id: ${id}, Error: ${e}`;
    logger.error(errorMessage);
    throw _boom.default.boomify(e, {
      message: errorMessage
    });
  }
}