"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableActionButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TableActionButton = ({
  iconType,
  dataTestSubjPostfix,
  isDisabled,
  label,
  tooltipText,
  onClick
}) => {
  const buttonContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    css: {
      marginRight: '8px'
    }
  }), label);
  const unwrappedButton = !isDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `aiopsTableActionButton${dataTestSubjPostfix} enabled`,
    onClick: onClick,
    color: 'text',
    "aria-label": tooltipText
  }, buttonContent) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": `aiopsTableActionButton${dataTestSubjPostfix} disabled`,
    size: "s",
    color: 'subdued',
    "aria-label": tooltipText,
    css: {
      fontWeight: 500
    }
  }, buttonContent);
  if (tooltipText) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: tooltipText
    }, unwrappedButton);
  }
  return unwrappedButton;
};
exports.TableActionButton = TableActionButton;