"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldValidationCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _mlCategoryValidator = require("@kbn/ml-category-validator");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldValidationCallout = ({
  validationResults
}) => {
  if (validationResults === null) {
    return null;
  }
  if (validationResults.overallValidStatus === _mlCategoryValidator.CATEGORY_EXAMPLES_VALIDATION_STATUS.VALID) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    iconType: 'alert',
    title: _i18n.i18n.translate('xpack.aiops.logCategorization.fieldValidationTitle', {
      defaultMessage: 'The selected field is possibly not suitable for pattern analysis'
    })
  }, validationResults.validationChecks.filter(check => check.valid !== _mlCategoryValidator.CATEGORY_EXAMPLES_VALIDATION_STATUS.VALID).map(check => /*#__PURE__*/_react.default.createElement("div", {
    key: check.id
  }, check.message)));
};
exports.FieldValidationCallout = FieldValidationCallout;