"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AiAssistantSelectionPage = AiAssistantSelectionPage;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _docLinks = require("@kbn/doc-links");
var _app_context = require("../../app_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function AiAssistantSelectionPage() {
  var _capabilities$observa;
  const {
    capabilities,
    setBreadcrumbs,
    navigateToApp,
    buildFlavor,
    kibanaBranch,
    securityAIAssistantEnabled
  } = (0, _app_context.useAppContext)();
  const aiAssistantManagementSelection = capabilities.management.kibana.aiAssistantManagementSelection;
  const observabilityAIAssistantEnabled = (_capabilities$observa = capabilities.observabilityAIAssistant) === null || _capabilities$observa === void 0 ? void 0 : _capabilities$observa.show;
  const observabilityDoc = (0, _docLinks.getDocLinks)({
    buildFlavor,
    kibanaBranch
  }).observability.aiAssistant;
  const securityDoc = (0, _docLinks.getDocLinks)({
    buildFlavor,
    kibanaBranch
  }).securitySolution.aiAssistant;
  const isSecurityAIAssistantEnabled = securityAIAssistantEnabled && aiAssistantManagementSelection;
  (0, _react.useEffect)(() => {
    setBreadcrumbs([{
      text: _i18n.i18n.translate('aiAssistantManagementSelection.breadcrumb.index', {
        defaultMessage: 'AI Assistant'
      })
    }]);
  }, [setBreadcrumbs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    "data-test-subj": "pluginsAiAssistantSelectionPageTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSettingsPage.h2.aIAssistantLabel', {
    defaultMessage: 'AI Assistant'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "pluginsAiAssistantSelectionPageDescription"
  }, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSettingsPage.descriptionTextLabel', {
    defaultMessage: 'AI Assistants use generative AI to help your team by explaining errors, suggesting remediation, and helping you request, analyze, and visualize your data.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "aiAssistantSelectionPageObservabilityCard",
    description: /*#__PURE__*/_react.default.createElement("div", null, !observabilityAIAssistantEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "warning",
      "data-test-subj": "pluginsAiAssistantSelectionPageObservabilityDocumentationCallout",
      title: _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.observabilityAi.thisFeatureIsDisabledCallOutLabel', {
        defaultMessage: 'This feature is disabled.'
      }),
      size: "s",
      className: "eui-displayInlineBlock"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })) : null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "aiAssistantManagementSelection.aiAssistantSelectionPage.obsAssistant.documentationLinkDescription",
      defaultMessage: "For more info, refer to our {documentation}.",
      values: {
        documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "pluginsAiAssistantSelectionPageDocumentationLink",
          external: true,
          target: "_blank",
          href: observabilityDoc
        }, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.obsAssistant.documentationLinkLabel', {
          defaultMessage: 'documentation'
        }))
      }
    })), observabilityAIAssistantEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "gear",
      "data-test-subj": "pluginsAiAssistantSelectionPageButton",
      onClick: () => navigateToApp('management', {
        path: 'kibana/observabilityAiAssistantManagement'
      })
    }, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.obsAssistant.manageSettingsButtonLabel', {
      defaultMessage: 'Manage Settings'
    }))),
    display: "plain",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "logoObservability"
    }),
    isDisabled: !observabilityAIAssistantEnabled,
    title: _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.observabilityLabel', {
      defaultMessage: 'Elastic AI Assistant for Observability and Search'
    }),
    titleSize: "xs"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    description: /*#__PURE__*/_react.default.createElement("div", null, !isSecurityAIAssistantEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "warning",
      "data-test-subj": "pluginsAiAssistantSelectionPageSecurityDocumentationCallout",
      title: _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.securityAi.thisFeatureIsDisabledCallOutLabel', {
        defaultMessage: 'This feature is disabled.'
      }),
      size: "s",
      className: "eui-displayInlineBlock"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })) : null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "aiAssistantManagementSelection.aiAssistantSelectionPage.securityAssistant.documentationLinkDescription",
      defaultMessage: "For more info, refer to our {documentation}.",
      values: {
        documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "securityAiAssistantSelectionPageDocumentationLink",
          external: true,
          target: "_blank",
          href: securityDoc
        }, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSettingsPage.securityAssistant.documentationLinkLabel', {
          defaultMessage: 'documentation'
        }))
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "pluginsAiAssistantSelectionSecurityPageButton",
      iconType: "gear",
      onClick: () => navigateToApp('management', {
        path: 'kibana/securityAiAssistantManagement'
      }),
      disabled: !isSecurityAIAssistantEnabled
    }, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.securityAssistant.manageSettingsButtonLabel', {
      defaultMessage: 'Manage Settings'
    }))),
    display: "plain",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "logoSecurity"
    }),
    isDisabled: !isSecurityAIAssistantEnabled,
    title: _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.securityLabel', {
      defaultMessage: 'Elastic AI Assistant for Security'
    }),
    titleSize: "xs"
  }))));
}