"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTourFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _popover = require("../popover");
var _button = require("../button");
var _flex = require("../flex");
var _tour_step_indicator = require("./tour_step_indicator");
var _tour_footer = require("./_tour_footer.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiTourFooter = exports.EuiTourFooter = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var footerAction = _ref.footerAction,
    step = _ref.step,
    stepsTotal = _ref.stepsTotal,
    onFinish = _ref.onFinish;
  var footerStyles = (0, _services.useEuiMemoizedStyles)(_tour_footer.euiTourFooterStyles);
  var customFooterAction = (0, _react.useMemo)(function () {
    if (!footerAction) return null;
    return Array.isArray(footerAction) ? (0, _react2.jsx)(_flex.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      justifyContent: "flexEnd",
      responsive: false,
      wrap: true
    }, footerAction.map(function (action, index) {
      return (0, _react2.jsx)(_flex.EuiFlexItem, {
        key: index,
        grow: false
      }, action);
    })) : (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, footerAction);
  }, [footerAction]);
  var indicators = (0, _react.useMemo)(function () {
    if (stepsTotal <= 1) return null;
    return (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)("ul", {
      className: "euiTourFooter__stepList"
    }, _toConsumableArray(Array(stepsTotal).keys()).map(function (_, i) {
      var status = 'complete';
      if (step === i + 1) {
        status = 'active';
      } else if (step <= i) {
        status = 'incomplete';
      }
      return (0, _react2.jsx)(_tour_step_indicator.EuiTourStepIndicator, {
        key: i,
        number: i + 1,
        status: status
      });
    })));
  }, [step, stepsTotal]);
  return (0, _react2.jsx)(_popover.EuiPopoverFooter, {
    css: footerStyles.euiTourFooter,
    className: "euiTourFooter"
  }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    responsive: false,
    justifyContent: stepsTotal > 1 ? 'spaceBetween' : 'flexEnd',
    alignItems: "center"
  }, indicators, footerAction ? customFooterAction : (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    tokens: ['euiTourFooter.endTour', 'euiTourFooter.skipTour', 'euiTourFooter.closeTour'],
    defaults: ['End tour', 'Skip tour', 'Close tour']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 3),
      endTour = _ref3[0],
      skipTour = _ref3[1],
      closeTour = _ref3[2];
    return (0, _react2.jsx)(_button.EuiButtonEmpty, {
      onClick: onFinish,
      color: "text",
      flush: "right",
      size: "xs"
    }, stepsTotal > 1 ? stepsTotal === step ? endTour : skipTour : closeTour);
  }))));
});
EuiTourFooter.displayName = '_EuiTourFooter';