"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GUTTER_SIZES = exports.EuiListGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _list_group_item = require("./list_group_item");
var _list_group = require("./list_group.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "listItems", "style", "flush", "bordered", "gutterSize", "wrapText", "maxWidth", "showToolTips", "color", "size", "ariaLabelledby"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var GUTTER_SIZES = exports.GUTTER_SIZES = ['none', 's', 'm'];
var EuiListGroup = exports.EuiListGroup = function EuiListGroup(_ref) {
  var children = _ref.children,
    className = _ref.className,
    listItems = _ref.listItems,
    style = _ref.style,
    _ref$flush = _ref.flush,
    flush = _ref$flush === void 0 ? false : _ref$flush,
    _ref$bordered = _ref.bordered,
    bordered = _ref$bordered === void 0 ? false : _ref$bordered,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 's' : _ref$gutterSize,
    _ref$wrapText = _ref.wrapText,
    wrapText = _ref$wrapText === void 0 ? false : _ref$wrapText,
    _ref$maxWidth = _ref.maxWidth,
    maxWidth = _ref$maxWidth === void 0 ? true : _ref$maxWidth,
    _ref$showToolTips = _ref.showToolTips,
    showToolTips = _ref$showToolTips === void 0 ? false : _ref$showToolTips,
    color = _ref.color,
    size = _ref.size,
    ariaLabelledby = _ref.ariaLabelledby,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiListGroup', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_list_group.euiListGroupStyles);
  var cssStyles = [styles.euiListGroup, styles[gutterSize], flush && styles.flush, bordered && styles.bordered, maxWidth === true && styles.maxWidthDefault];
  var maxWidthStyle = (0, _react.useMemo)(function () {
    if (maxWidth && maxWidth !== true) {
      return (0, _global_styling.logicalStyle)('max-width', maxWidth);
    }
  }, [maxWidth]);
  var renderedListItems = (0, _react.useMemo)(function () {
    if (listItems && listItems.length) {
      return listItems.map(function (item, index) {
        return (0, _react2.jsx)(_list_group_item.EuiListGroupItem, _extends({
          key: "title-".concat(index),
          showToolTip: showToolTips,
          wrapText: wrapText
          // we're passing the parent `color` and `size` down to the children
          // so that they can inherit it if they don't have one
          ,
          color: color,
          size: size
        }, item));
      });
    }
  }, [listItems, color, size, wrapText, showToolTips]);
  var listItemsOrChildren = renderedListItems ||
  // Note that there's no point in memoizing `children`, as JSX changes every rerender
  _react.default.Children.map(children, function (child) {
    if ( /*#__PURE__*/_react.default.isValidElement(child)) {
      return (0, _services.cloneElementWithCss)(child, _objectSpread(_objectSpread({
        // we're passing the parent `color` and `size` down to the children
        // so that they can inherit it if they don't have one
        color: color,
        size: size
      }, showToolTips && {
        showToolTip: true
      }), child.props));
    }
  });
  return (0, _react2.jsx)("ul", _extends({
    className: classes,
    css: cssStyles,
    style: _objectSpread(_objectSpread({}, style), maxWidthStyle),
    "aria-labelledby": ariaLabelledby
  }, rest), listItemsOrChildren);
};
EuiListGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Add a border to the list container
       */
  bordered: _propTypes.default.bool,
  /**
       * Remove container padding, stretching list items to the edges
       */
  flush: _propTypes.default.bool,
  /**
       * Spacing between list items
       */
  gutterSize: _propTypes.default.any,
  /**
       * Items to display in this group. See {@link EuiListGroupItem}
       */
  listItems: _propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    /**
         * Size of the label text
         */
    size: _propTypes.default.any,
    /**
         * By default the item will get the color `text`.
         * You can customize the color of the item by passing a color name.
         */
    color: _propTypes.default.any,
    /**
         * Content to be displayed in the list item
         */
    label: _propTypes.default.node.isRequired,
    /**
         * Apply styles indicating an item is active
         */
    isActive: _propTypes.default.bool,
    /**
         * Apply styles indicating an item is disabled
         */
    isDisabled: _propTypes.default.bool,
    /**
         * Make the list item label a link.
         * While permitted, `href` and `onClick` should not be used together in most cases and may create problems.
         */
    href: _propTypes.default.string,
    rel: _propTypes.default.string,
    target: _propTypes.default.string,
    /**
         * Set to true to show an icon indicating that it is an external link;
         * Defaults to true if `target="_blank"`
         */
    external: _propTypes.default.bool,
    /**
         * Adds `EuiIcon` of `EuiIcon.type`
         */
    iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkCircle", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "code", "codeApp", "color", "comment", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controls", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "export", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flask", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "info", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plugs", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "question", "quote", "readOnly", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "web", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
    /**
         * Further extend the props applied to EuiIcon
         */
    iconProps: _propTypes.default.any,
    /**
         * Custom node to pass as the icon. Cannot be used in conjunction
         * with `iconType` and `iconProps`.
         */
    icon: _propTypes.default.element,
    /**
         * Display tooltip on list item
         */
    showToolTip: _propTypes.default.bool,
    /**
         * An object of {@link EuiListGroupItemExtraAction} props.
         * Adds an `EuiButtonIcon` to the right side of the item; `iconType` is required;
         * pass `alwaysShow` if you don't want the default behavior of only showing on hover
         */
    extraAction: _propTypes.default.shape({
      alwaysShow: _propTypes.default.bool,
      type: _propTypes.default.any,
      onClick: _propTypes.default.func,
      iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkCircle", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "code", "codeApp", "color", "comment", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controls", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "export", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flask", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "info", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plugs", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "question", "quote", "readOnly", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "web", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]).isRequired,
      /**
         * Any of the named color palette options.
         *
         * Do not use the following colors for standalone buttons directly,
         * they exist to serve other components:
         *  - accent
         *  - warning
         *  - neutral
         *  - risk
         */
      color: _propTypes.default.any,
      "aria-label": _propTypes.default.string,
      "aria-labelledby": _propTypes.default.string,
      isDisabled: _propTypes.default.bool,
      /**
         * Overall size of button.
         * Matches the sizes of other EuiButtons
         */
      size: _propTypes.default.any,
      /**
         * Size of the icon only.
         * This will not affect the overall size of the button
         */
      iconSize: _propTypes.default.any,
      /**
         * Applies the boolean state as the `aria-pressed` property to create a toggle button.
         * *Only use when the readable text does not change between states.*
         */
      isSelected: _propTypes.default.bool,
      /**
         * Sets the display style for matching other EuiButton types.
         * `base` is equivalent to a typical EuiButton
         * `fill` is equivalent to a filled EuiButton
         * `empty` (default) is equivalent to an EuiButtonEmpty
         */
      display: _propTypes.default.any,
      /**
         * Disables the button and changes the icon to a loading spinner
         */
      isLoading: _propTypes.default.bool,
      className: _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any,
      buttonRef: _propTypes.default.any
    }),
    /**
         * Make the list item label a button.
         * While permitted, `href` and `onClick` should not be used together in most cases and may create problems.
         */
    onClick: _propTypes.default.func,
    /**
         * Allow link text to wrap
         */
    wrapText: _propTypes.default.bool,
    /**
         * Pass-through ref reference specifically for targeting
         * instances where the item content is rendered as a `button`
         */
    buttonRef: _propTypes.default.any,
    /**
         * Text to be displayed in the tooltip when `showToolTip` is true.
         * By default the text will be same as the label text.
         */
    toolTipText: _propTypes.default.string,
    /**
         * Allows customizing the tooltip shown when `showToolTip` is true.
         * Accepts any props that [EuiToolTip](/#/display/tooltip) accepts.
         */
    toolTipProps: _propTypes.default.any
  }).isRequired),
  /**
       * Change the colors of all `listItems` at once
       * @default text
       */
  color: _propTypes.default.any,
  /**
       * Change the size of all `listItems` at once
       * @default m
       */
  size: _propTypes.default.any,
  /**
       * Sets the max-width of the page.
       * Set to `true` to use the default size,
       * set to `false` to not restrict the width,
       * or set to a number/string for a custom CSS width/measurement.
       */
  maxWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.any.isRequired]),
  /**
       * Display tooltips on all list items
       */
  showToolTips: _propTypes.default.bool,
  /**
       * Allow link text to wrap vs truncated
       */
  wrapText: _propTypes.default.bool,
  ariaLabelledby: _propTypes.default.string
};