"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridDraggableHeaderStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../../global_styling");
var _templateObject;
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "pfqu74-euiDataGridHeaderDroppable",
  styles: "display:flex;label:euiDataGridHeaderDroppable;"
} : {
  name: "pfqu74-euiDataGridHeaderDroppable",
  styles: "display:flex;label:euiDataGridHeaderDroppable;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiDataGridDraggableHeaderStyles = exports.euiDataGridDraggableHeaderStyles = function euiDataGridDraggableHeaderStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    euiDataGridHeaderDroppable: _ref,
    // The resizer must be positioned outside the draggable component to ensure both work independently
    euiDataGridHeaderCellDraggableWrapper: /*#__PURE__*/(0, _react.css)("position:relative;.euiDataGridColumnResizer::after{", (0, _global_styling.logicalCSS)('margin-left', "-".concat(euiTheme.border.width.thick)), ";};label:euiDataGridHeaderCellDraggableWrapper;"),
    // override internal styling from @hello-pangea/dnd to ensure positioning
    euiDataGridHeaderCellDraggable: /*#__PURE__*/(0, _react.css)("display:flex;", (0, _global_styling.logicalCSS)('height', '100%'), ";;label:euiDataGridHeaderCellDraggable;"),
    // Add more visual affordance to keyboard drags (raises cell slightly to show green droppable bg)
    // Using animation as transition doesn't seem to work (a tale as old as EuiDataGrid...)
    isKeyboardDragging: /*#__PURE__*/(0, _react.css)("animation-name:", (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n        from { transform: translateY(0); }\n        to { transform: translateY(-", "); }\n      "])), euiTheme.size.s), ";animation-iteration-count:1;animation-fill-mode:forwards;", _global_styling.euiCanAnimate, "{animation-duration:", euiTheme.animation.fast, ";};label:isKeyboardDragging;"),
    // Ensure correct cell background colors on drag
    underline: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.colors.emptyShade, ";;label:underline;"),
    shade: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.colors.lightestShade, ";;label:shade;"),
    noLeadingBorder: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-left', 'none !important'), ";;label:noLeadingBorder;")
  };
};