"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCollapsibleNavLinkStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _collapsible_nav_item = require("./collapsible_nav_item.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiCollapsibleNavLinkStyles = exports.euiCollapsibleNavLinkStyles = function euiCollapsibleNavLinkStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var sharedStyles = (0, _collapsible_nav_item.euiCollapsibleNavItemVariables)(euiThemeContext);
  return {
    // Shared between all links
    euiCollapsibleNavLink: /*#__PURE__*/(0, _react.css)("display:flex;align-items:center;", (0, _global_styling.logicalCSS)('height', sharedStyles.height), " padding:", sharedStyles.padding, ";font-size:", sharedStyles.fontSize, ";line-height:", sharedStyles.lineHeight, ";color:", sharedStyles.color, ";border-radius:", sharedStyles.borderRadius, ";&:focus{outline-offset:-", euiTheme.focus.width, ";text-decoration-thickness:unset;}[class*='euiLink__externalIcon']{", (0, _global_styling.logicalCSS)('margin-right', euiTheme.size.xxs), " color:", sharedStyles.rightIconColor, ";};label:euiCollapsibleNavLink;"),
    isSelected: /*#__PURE__*/(0, _react.css)("background-color:", sharedStyles.backgroundSelectedColor, ";;label:isSelected;"),
    isTopItem: {
      isTopItem: /*#__PURE__*/(0, _react.css)("font-weight:", euiTheme.font.weight.semiBold, ";gap:", euiTheme.size.base, ";&:is(button){inline-size:calc(\n            100% - ", (0, _global_styling.mathWithUnits)(sharedStyles.padding, function (x) {
        return x * 2;
      }), "\n          );};label:isTopItem;"),
      isNotAccordion: /*#__PURE__*/(0, _react.css)("margin:", sharedStyles.padding, ";;label:isNotAccordion;"),
      isInteractive: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{transition:background-color ", sharedStyles.animation, ";}&:hover,&:focus-visible{background-color:", sharedStyles.backgroundHoverColor, ";};label:isInteractive;")
    },
    isSubItem: /*#__PURE__*/(0, _react.css)("font-weight:", euiTheme.font.weight.regular, ";gap:", euiTheme.size.s, ";;label:isSubItem;")
  };
};