"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLineSeriesStyles = getLineSeriesStyles;
exports.getAreaSeriesStyles = getAreaSeriesStyles;
const common_1 = require("../../../utils/common");
function getLineSeriesStyles(baseStyle, seriesStyle) {
    if (!seriesStyle)
        return baseStyle;
    const isolatedPointStyleOverrides = (0, common_1.mergePartial)(baseStyle.isolatedPoint, seriesStyle.isolatedPoint, undefined, seriesStyle.point ? [seriesStyle.point] : []);
    return (0, common_1.mergePartial)(baseStyle, {
        isolatedPoint: {
            ...isolatedPointStyleOverrides,
            visible: seriesStyle?.isolatedPoint?.visible ?? baseStyle.isolatedPoint.visible,
        },
    }, undefined, [seriesStyle]);
}
function getAreaSeriesStyles(baseStyle, seriesStyle) {
    if (!seriesStyle)
        return baseStyle;
    const isolatedPointStyleOverrides = (0, common_1.mergePartial)(baseStyle.isolatedPoint, seriesStyle.isolatedPoint, undefined, seriesStyle.point ? [seriesStyle.point] : []);
    return (0, common_1.mergePartial)(baseStyle, {
        isolatedPoint: {
            ...isolatedPointStyleOverrides,
            visible: seriesStyle?.isolatedPoint?.visible ?? baseStyle.isolatedPoint.visible,
        },
    }, undefined, [seriesStyle]);
}
//# sourceMappingURL=line_area_style.js.map