"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeStateManagement = initializeStateManagement;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _lodash = require("lodash");
var _helper = require("../helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Due to inline editing we need something advanced to handle the state
 * management at the embeddable level, so here's the initializers for it
 */
function initializeStateManagement(initialState, internalApi) {
  const [attributes$, attributesComparator] = (0, _helper.buildObservableVariable)(internalApi.attributes$);
  const [savedObjectId$, savedObjectIdComparator] = (0, _helper.buildObservableVariable)(initialState.savedObjectId);
  const [dataViews$] = (0, _helper.buildObservableVariable)(internalApi.dataViews$);
  const [dataLoading$] = (0, _helper.buildObservableVariable)(internalApi.dataLoading$);
  const [rendered$] = (0, _helper.buildObservableVariable)(internalApi.hasRenderCompleted$);
  const [abortController$, abortControllerComparator] = (0, _helper.buildObservableVariable)(internalApi.expressionAbortController$);

  // This is the way to communicate to the embeddable panel to render a blocking error with the
  // default panel error component - i.e. cannot find a Lens SO type of thing.
  // For Lens specific errors, we use a Lens specific error component.
  const [blockingError$] = (0, _helper.buildObservableVariable)(internalApi.blockingError$);
  return {
    api: {
      updateAttributes: internalApi.updateAttributes,
      updateSavedObjectId: newSavedObjectId => savedObjectId$.next(newSavedObjectId),
      savedObjectId$,
      dataViews$,
      dataLoading$,
      blockingError$,
      rendered$
    },
    serialize: () => {
      return {
        attributes: attributes$.getValue(),
        savedObjectId: savedObjectId$.getValue(),
        abortController: abortController$.getValue()
      };
    },
    comparators: {
      // need to force cast this to make it pass the type check
      // @TODO: workout why this is needed
      attributes: attributesComparator,
      savedObjectId: savedObjectIdComparator,
      abortController: abortControllerComparator,
      sharingSavedObjectProps: (0, _presentationPublishing.getUnchangingComparator)(),
      managed: (0, _presentationPublishing.getUnchangingComparator)()
    },
    cleanup: _lodash.noop
  };
}