"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildObservableVariable = buildObservableVariable;
exports.createEmptyLensState = createEmptyLensState;
exports.deserializeState = deserializeState;
exports.emptySerializer = emptySerializer;
exports.extractInheritedViewModeObservable = extractInheritedViewModeObservable;
exports.getParentContext = getParentContext;
exports.getRenderMode = getRenderMode;
exports.getViewMode = getViewMode;
exports.isTextBasedLanguage = isTextBasedLanguage;
exports.makeComparator = makeComparator;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createEmptyLensState(visualizationType = null, title, description, query, filters) {
  const isTextBased = query && (0, _esQuery.isOfAggregateQueryType)(query);
  return {
    attributes: {
      title: title !== null && title !== void 0 ? title : '',
      description: description !== null && description !== void 0 ? description : '',
      visualizationType,
      references: [],
      state: {
        query: query || {
          query: '',
          language: 'kuery'
        },
        filters: filters || [],
        internalReferences: [],
        datasourceStates: {
          ...(isTextBased ? {
            textBased: {}
          } : {
            formBased: {}
          })
        },
        visualization: {}
      }
    }
  };
}

// Shared logic to ensure the attributes are correctly loaded
// Make sure to inject references from the container down to the runtime state
// this ensure migrations/copy to spaces works correctly
async function deserializeState(attributeService, rawState, references) {
  if (rawState.savedObjectId) {
    try {
      const {
        attributes,
        managed,
        sharingSavedObjectProps
      } = await attributeService.loadFromLibrary(rawState.savedObjectId);
      return {
        ...rawState,
        attributes,
        managed,
        sharingSavedObjectProps
      };
    } catch (e) {
      // return an empty Lens document if no saved object is found
      return {
        ...rawState,
        attributes: createEmptyLensState().attributes
      };
    }
  }
  // Inject applied only to by-value SOs
  return attributeService.injectReferences('attributes' in rawState ? rawState : {
    attributes: rawState
  }, references !== null && references !== void 0 && references.length ? references : undefined);
}
function emptySerializer() {
  return {};
}
function makeComparator(observable) {
  return [observable, newValue => observable.next(newValue), _fastDeepEqual.default];
}

/**
 * Helper function to either extract an observable from an API or create a new one
 * with a default value to start with.
 * Note that extracting from the API will make subscription emit if the value changes upstream
 * as it keeps the original reference without cloning.
 * @returns the observable and a comparator to use for detecting "unsaved changes" on it
 */
function buildObservableVariable(variable) {
  if (variable instanceof _rxjs.BehaviorSubject) {
    return [variable, makeComparator(variable)];
  }
  const variable$ = new _rxjs.BehaviorSubject(variable);
  return [variable$, makeComparator(variable$)];
}
function isTextBasedLanguage(state) {
  var _state$attributes;
  return (0, _esQuery.isOfAggregateQueryType)((_state$attributes = state.attributes) === null || _state$attributes === void 0 ? void 0 : _state$attributes.state.query);
}
function getViewMode(api) {
  return (0, _presentationPublishing.apiPublishesViewMode)(api) ? (0, _presentationPublishing.getInheritedViewMode)(api) : undefined;
}
function getRenderMode(api) {
  var _getViewMode;
  const mode = (_getViewMode = getViewMode(api)) !== null && _getViewMode !== void 0 ? _getViewMode : 'view';
  return mode === 'print' ? 'view' : mode;
}
function apiHasExecutionContextFunction(api) {
  return (0, _lodash.isObject)(api) && 'getAppContext' in api && typeof api.getAppContext === 'function';
}
function getParentContext(parentApi) {
  if ((0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
    return parentApi.executionContext;
  }
  if (apiHasExecutionContextFunction(parentApi)) {
    return {
      type: parentApi.getAppContext().currentAppId
    };
  }
  return;
}
function extractInheritedViewModeObservable(parentApi) {
  if ((0, _presentationPublishing.apiPublishesViewMode)(parentApi)) {
    return parentApi.viewMode$;
  }
  if ((0, _presentationPublishing.apiHasParentApi)(parentApi)) {
    return extractInheritedViewModeObservable(parentApi.parentApi);
  }
  return new _rxjs.BehaviorSubject('view');
}