"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareEventHandler = void 0;
var _public = require("@kbn/visualizations-plugin/public");
var _esQuery = require("@kbn/es-query");
var _types = require("../../types");
var _utils = require("../../utils");
var _helper = require("../helper");
var _logger = require("../logger");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const prepareEventHandler = (api, getState, callbacks, {
  data,
  uiActions,
  visualizationMap
}, disableTriggers) => async event => {
  var _eventHandler, _visualizationMap$cur;
  if (!(uiActions !== null && uiActions !== void 0 && uiActions.getTrigger) || disableTriggers) {
    return;
  }
  (0, _logger.addLog)(`onEvent$`);
  let eventHandler;
  let shouldExecuteDefaultTriggers = true;
  if ((0, _types.isLensBrushEvent)(event)) {
    eventHandler = callbacks.onBrushEnd;
  } else if ((0, _types.isLensFilterEvent)(event) || (0, _types.isLensMultiFilterEvent)(event)) {
    eventHandler = callbacks.onFilter;
  } else if ((0, _types.isLensTableRowContextMenuClickEvent)(event)) {
    eventHandler = callbacks.onTableRowClick;
  }
  const currentState = getState();
  (_eventHandler = eventHandler) === null || _eventHandler === void 0 ? void 0 : _eventHandler({
    ...event.data,
    preventDefault: () => {
      shouldExecuteDefaultTriggers = false;
    }
  });
  if ((0, _types.isLensFilterEvent)(event) || (0, _types.isLensMultiFilterEvent)(event) || (0, _types.isLensBrushEvent)(event)) {
    if (shouldExecuteDefaultTriggers) {
      // if the embeddable is located in an app where there is the Unified search bar with the ES|QL editor, then use this query
      // otherwise use the query from the saved object
      let esqlQuery;
      if ((0, _helper.isTextBasedLanguage)(currentState)) {
        const query = data.query.queryString.getQuery();
        esqlQuery = (0, _esQuery.isOfAggregateQueryType)(query) ? query : currentState.attributes.state.query;
      }
      uiActions.getTrigger(_public.VIS_EVENT_TO_TRIGGER[event.name]).exec({
        data: {
          ...event.data,
          timeFieldName: event.data.timeFieldName || (0, _utils.inferTimeField)(data.datatableUtilities, event),
          query: esqlQuery
        },
        embeddable: api
      });
    }
  }
  if ((0, _types.isLensTableRowContextMenuClickEvent)(event)) {
    if (shouldExecuteDefaultTriggers) {
      uiActions.getTrigger(_public.VIS_EVENT_TO_TRIGGER[event.name]).exec({
        data: event.data,
        embeddable: api
      }, true);
    }
  }
  const onEditAction = currentState.attributes.visualizationType ? (_visualizationMap$cur = visualizationMap[currentState.attributes.visualizationType]) === null || _visualizationMap$cur === void 0 ? void 0 : _visualizationMap$cur.onEditAction : undefined;

  // We allow for edit actions in the Embeddable for display purposes only (e.g. changing the datatable sort order).
  // No state changes made here with an edit action are persisted.
  if ((0, _types.isLensEditEvent)(event) && onEditAction) {
    // updating the state would trigger a reload
    api.updateAttributes({
      ...currentState.attributes,
      state: {
        ...currentState.attributes.state,
        visualization: onEditAction(currentState.attributes.state.visualization, event)
      }
    });
  }
};
exports.prepareEventHandler = prepareEventHandler;