"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadEmbeddableData = loadEmbeddableData;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _constants = require("../../common/constants");
var _expression_params = require("./expressions/expression_params");
var _callbacks = require("./expressions/callbacks");
var _api = require("./user_messages/api");
var _telemetry = require("./expressions/telemetry");
var _type_guards = require("./type_guards");
var _helper = require("./helper");
var _logger = require("./logger");
var _update_data_views = require("./expressions/update_data_views");
var _merged_search_context = require("./expressions/merged_search_context");
var _utils = require("./initializers/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const blockingMessageDisplayLocations = ['visualization', 'visualizationOnEmbeddable'];
function getSearchContext(parentApi, esqlVariables = []) {
  var _unifiedSearch$$times;
  const unifiedSearch$ = (0, _presentationPublishing.apiPublishesUnifiedSearch)(parentApi) ? (0, _lodash.pick)(parentApi, 'filters$', 'query$', 'timeslice$', 'timeRange$') : {
    filters$: new _rxjs.BehaviorSubject(undefined),
    query$: new _rxjs.BehaviorSubject(undefined),
    timeslice$: new _rxjs.BehaviorSubject(undefined),
    timeRange$: new _rxjs.BehaviorSubject(undefined)
  };
  return {
    esqlVariables,
    filters: unifiedSearch$.filters$.getValue(),
    query: unifiedSearch$.query$.getValue(),
    timeRange: unifiedSearch$.timeRange$.getValue(),
    timeslice: (_unifiedSearch$$times = unifiedSearch$.timeslice$) === null || _unifiedSearch$$times === void 0 ? void 0 : _unifiedSearch$$times.getValue()
  };
}

/**
 * The function computes the expression used to render the panel and produces the necessary props
 * for the ExpressionWrapper component, binding any outer context to them.
 * @returns
 */
function loadEmbeddableData(uuid, getState, api, parentApi, internalApi, services, metaInfo) {
  const {
    onLoad,
    onBeforeBadgesRender,
    ...callbacks
  } = (0, _type_guards.apiHasLensComponentCallbacks)(parentApi) ? parentApi : {};

  // Some convenience api for the user messaging
  const {
    getUserMessages,
    addUserMessages,
    updateBlockingErrors,
    updateValidationErrors,
    updateWarnings,
    resetMessages,
    updateMessages
  } = (0, _api.buildUserMessagesHelpers)(api, internalApi, services, onBeforeBadgesRender, metaInfo);
  const dispatchBlockingErrorIfAny = () => {
    const blockingErrors = getUserMessages(blockingMessageDisplayLocations, {
      severity: 'error'
    });
    updateValidationErrors(blockingErrors);
    updateBlockingErrors(blockingErrors);
    if (blockingErrors.length > 0) {
      internalApi.dispatchError();
    }
    return blockingErrors.length > 0;
  };
  const onRenderComplete = () => {
    updateMessages(getUserMessages('embeddableBadge'));
    // No issues so far, blocking errors are handled directly by Lens from this point on
    if (!dispatchBlockingErrorIfAny()) {
      internalApi.dispatchRenderComplete();
    }
  };
  const [controlESQLVariables$] = (0, _helper.buildObservableVariable)([]);
  async function reload(
  // make reload easier to debug
  sourceId) {
    var _currentState$attribu;
    (0, _logger.addLog)(`Embeddable reload reason: ${sourceId}`);
    resetMessages();

    // reset the render on reload
    internalApi.dispatchRenderStart();

    // notify about data loading
    internalApi.updateDataLoading(true);

    // the component is ready to load
    onLoad === null || onLoad === void 0 ? void 0 : onLoad(true);
    const currentState = getState();
    const getExecutionContext = () => {
      const parentContext = (0, _helper.getParentContext)(parentApi);
      const lastState = getState();
      if (lastState.attributes) {
        var _lastState$attributes;
        const child = {
          type: 'lens',
          name: (_lastState$attributes = lastState.attributes.visualizationType) !== null && _lastState$attributes !== void 0 ? _lastState$attributes : '',
          id: uuid || 'new',
          description: lastState.attributes.title || lastState.title || '',
          url: `${services.coreStart.application.getUrlForApp('lens')}${(0, _constants.getEditPath)(lastState.savedObjectId)}`
        };
        return parentContext ? {
          ...parentContext,
          child
        } : child;
      }
    };
    const onDataCallback = adapters => {
      var _adapters$tables;
      internalApi.updateVisualizationContext({
        activeData: adapters === null || adapters === void 0 ? void 0 : (_adapters$tables = adapters.tables) === null || _adapters$tables === void 0 ? void 0 : _adapters$tables.tables
      });

      // data has loaded
      internalApi.updateDataLoading(false);
      // The third argument here is an observable to let the
      // consumer to be notified on data change
      onLoad === null || onLoad === void 0 ? void 0 : onLoad(false, adapters, api.dataLoading$);
      api.loadViewUnderlyingData();
      updateWarnings();
      // Render can still go wrong, so perfor a new check
      dispatchBlockingErrorIfAny();
    };
    const {
      onRender,
      onData,
      handleEvent,
      disableTriggers
    } = (0, _callbacks.prepareCallbacks)(api, internalApi, parentApi, getState, services, getExecutionContext(), onDataCallback, onRenderComplete, callbacks);
    const searchContext = (0, _merged_search_context.getMergedSearchContext)(currentState, getSearchContext(parentApi, controlESQLVariables$ === null || controlESQLVariables$ === void 0 ? void 0 : controlESQLVariables$.getValue()), api.timeRange$, parentApi, services);

    // Go concurrently: build the expression and fetch the dataViews
    const [{
      params,
      abortController,
      ...rest
    }, dataViewIds] = await Promise.all([(0, _expression_params.getExpressionRendererParams)(currentState, {
      searchContext,
      api,
      settings: {
        syncColors: currentState.syncColors,
        syncCursor: currentState.syncCursor,
        syncTooltips: currentState.syncTooltips
      },
      renderMode: (0, _helper.getRenderMode)(parentApi),
      services,
      searchSessionId: api.searchSessionId$.getValue(),
      abortController: internalApi.expressionAbortController$.getValue(),
      getExecutionContext,
      logError: (0, _telemetry.getLogError)(getExecutionContext),
      addUserMessages,
      onRender,
      onData,
      handleEvent,
      disableTriggers,
      updateBlockingErrors,
      getDisplayOptions: internalApi.getDisplayOptions
    }), (0, _update_data_views.getUsedDataViews)(currentState.attributes.references, (_currentState$attribu = currentState.attributes.state) === null || _currentState$attribu === void 0 ? void 0 : _currentState$attribu.adHocDataViews, services.dataViews)]);

    // update the visualization context before anything else
    // as it will be used to compute blocking errors also in case of issues
    internalApi.updateVisualizationContext({
      activeAttributes: currentState.attributes,
      mergedSearchContext: (params === null || params === void 0 ? void 0 : params.searchContext) || {},
      ...rest
    });

    // Publish the used dataViews on the Lens API
    internalApi.updateDataViews(dataViewIds);

    // This will catch also failed loaded dataViews
    const hasBlockingErrors = dispatchBlockingErrorIfAny();
    if ((params === null || params === void 0 ? void 0 : params.expression) != null && !hasBlockingErrors) {
      internalApi.updateExpressionParams(params);
    }
    internalApi.updateAbortController(abortController);
  }

  // Build a custom operator to be resused for various observables
  function waitUntilChanged() {
    return (0, _rxjs.pipe)((0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default), (0, _rxjs.skip)(1));
  }
  const mergedSubscriptions = (0, _rxjs.merge)(
  // on search context change, reload
  (0, _presentationPublishing.fetch$)(api).pipe((0, _rxjs.map)(() => 'searchContext')), controlESQLVariables$.pipe(waitUntilChanged(), (0, _rxjs.map)(() => 'ESQLvariables')),
  // On state change, reload
  // this is used to refresh the chart on inline editing
  // just make sure to avoid to rerender if there's no substantial change
  // make sure to debounce one tick to make the refresh work
  internalApi.attributes$.pipe(waitUntilChanged(), (0, _rxjs.tap)(() => {
    // the ES|QL query may have changed, so recompute the args for view underlying data
    if (api.isTextBasedLanguage()) {
      api.loadViewUnderlyingData();
    }
  }), (0, _rxjs.map)(() => 'attributes')), api.savedObjectId$.pipe(waitUntilChanged(), (0, _rxjs.map)(() => 'savedObjectId')), internalApi.overrides$.pipe(waitUntilChanged(), (0, _rxjs.map)(() => 'overrides')), internalApi.disableTriggers$.pipe(waitUntilChanged(), (0, _rxjs.map)(() => 'disableTriggers')));
  const subscriptions = [mergedSubscriptions.pipe((0, _rxjs.debounceTime)(0)).subscribe(reload),
  // In case of changes to the dashboard ES|QL controls, re-map them
  internalApi.esqlVariables$.subscribe(newVariables => {
    var _internalApi$attribut, _getEmbeddableVariabl;
    const query = (_internalApi$attribut = internalApi.attributes$.getValue().state) === null || _internalApi$attribut === void 0 ? void 0 : _internalApi$attribut.query;
    const esqlVariables = (_getEmbeddableVariabl = (0, _utils.getEmbeddableVariables)(query, newVariables)) !== null && _getEmbeddableVariabl !== void 0 ? _getEmbeddableVariabl : [];
    controlESQLVariables$.next(esqlVariables);
  }),
  // make sure to reload on viewMode change
  api.viewMode$.subscribe(() => {
    var _getState$enhancement, _getState$enhancement2;
    // only reload if drilldowns are set
    if ((_getState$enhancement = getState().enhancements) !== null && _getState$enhancement !== void 0 && (_getState$enhancement2 = _getState$enhancement.dynamicActions) !== null && _getState$enhancement2 !== void 0 && _getState$enhancement2.events.length) {
      reload('viewMode');
    }
  })];
  // There are few key moments when errors are checked and displayed:
  // * at setup time (here) before the first expression evaluation
  // * at runtime => when the expression is running and ES/Kibana server could emit errors)
  // * at data time => data has arrived but for something goes wrong
  // * at render time => rendering happened but somethign went wrong
  // Bubble the error up to the embeddable system if any
  dispatchBlockingErrorIfAny();
  return {
    cleanup: () => {
      for (const subscription of subscriptions) {
        subscription.unsubscribe();
      }
    }
  };
}