"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensAttributeService = getLensAttributeService;
exports.savedObjectToEmbeddableAttributes = void 0;
var _lodash = require("lodash");
var _embeddable_factory = require("../common/embeddable_factory");
var _persistence = require("./persistence");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const savedObjectToEmbeddableAttributes = savedObject => {
  return {
    ...savedObject.attributes,
    state: savedObject.attributes.state,
    references: savedObject.references
  };
};
exports.savedObjectToEmbeddableAttributes = savedObjectToEmbeddableAttributes;
function getLensAttributeService(core, startDependencies) {
  const savedObjectStore = new _persistence.SavedObjectIndexStore(startDependencies.contentManagement);
  return {
    loadFromLibrary: async savedObjectId => {
      const {
        meta,
        item
      } = await savedObjectStore.load(savedObjectId);
      return {
        attributes: {
          ...item.attributes,
          state: item.attributes.state,
          references: item.references
        },
        sharingSavedObjectProps: {
          aliasTargetId: meta.aliasTargetId,
          outcome: meta.outcome,
          aliasPurpose: meta.aliasPurpose,
          sourceId: item.id
        },
        managed: Boolean(item.managed)
      };
    },
    saveToLibrary: async (attributes, references, savedObjectId) => {
      const result = await savedObjectStore.save({
        ...attributes,
        state: attributes.state,
        references,
        savedObjectId
      });
      return result.savedObjectId;
    },
    checkForDuplicateTitle: async ({
      newTitle,
      isTitleDuplicateConfirmed,
      onTitleDuplicate = _lodash.noop,
      displayName = _constants.DOC_TYPE,
      lastSavedTitle = '',
      copyOnSave = false,
      id
    }) => {
      return {
        isDuplicate: await (0, _persistence.checkForDuplicateTitle)({
          id,
          title: newTitle,
          isTitleDuplicateConfirmed,
          displayName,
          lastSavedTitle,
          copyOnSave
        }, onTitleDuplicate, {
          client: savedObjectStore,
          ...core
        })
      };
    },
    // Make sure to inject references from the container down to the runtime state
    // this ensure migrations/copy to spaces works correctly
    injectReferences: (runtimeState, references) => {
      return (0, _embeddable_factory.inject)(runtimeState, references !== null && references !== void 0 ? references : runtimeState.attributes.references);
    },
    // Make sure to move the internal references into the parent references
    // so migrations/move to spaces can work properly
    extractReferences: runtimeState => {
      const {
        state,
        references
      } = (0, _embeddable_factory.extract)(runtimeState);
      return {
        rawState: state,
        references
      };
    }
  };
}