"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onDrop = void 0;
var _utils = require("../../../utils");
var _types = require("../../../types");
var _remove_column = require("../remove_column");
var _fieldlist_cache = require("../fieldlist_cache");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const onDrop = props => {
  var _sourceField$fieldNam;
  const {
    dropType,
    state,
    source,
    target
  } = props;
  if (!['field_add', 'field_replace', 'duplicate_compatible', 'replace_duplicate_compatible', 'replace_compatible', 'move_compatible', 'swap_compatible', 'reorder'].includes(dropType)) {
    return undefined;
  }
  const layer = state.layers[target.layerId];
  const allColumns = (0, _fieldlist_cache.retrieveLayerColumnsFromCache)(layer.columns, layer.query);
  const sourceField = allColumns.find(f => f.columnId === source.id || f.variable === source.id);
  const targetField = allColumns.find(f => f.columnId === target.columnId);
  const newColumn = {
    columnId: target.columnId,
    fieldName: sourceField !== null && sourceField !== void 0 && sourceField.variable ? `?${sourceField.variable}` : (_sourceField$fieldNam = sourceField === null || sourceField === void 0 ? void 0 : sourceField.fieldName) !== null && _sourceField$fieldNam !== void 0 ? _sourceField$fieldNam : '',
    meta: sourceField === null || sourceField === void 0 ? void 0 : sourceField.meta,
    variable: sourceField === null || sourceField === void 0 ? void 0 : sourceField.variable
  };
  let columns;
  switch (dropType) {
    case 'field_add':
    case 'duplicate_compatible':
    case 'replace_duplicate_compatible':
      columns = [...layer.columns.filter(c => c.columnId !== target.columnId), newColumn];
      break;
    case 'field_replace':
    case 'replace_compatible':
      columns = layer.columns.map(c => c.columnId === target.columnId ? newColumn : c);
      break;
    case 'move_compatible':
      columns = [...layer.columns, newColumn];
      break;
    case 'swap_compatible':
      const swapTwoColumns = c => {
        var _targetField$fieldNam;
        return c.columnId === target.columnId ? newColumn : c.columnId === source.columnId ? {
          columnId: source.columnId,
          fieldName: (_targetField$fieldNam = targetField === null || targetField === void 0 ? void 0 : targetField.fieldName) !== null && _targetField$fieldNam !== void 0 ? _targetField$fieldNam : '',
          meta: targetField === null || targetField === void 0 ? void 0 : targetField.meta
        } : c;
      };
      columns = layer.columns.map(swapTwoColumns);
      break;
    case 'reorder':
      const targetColumn = layer.columns.find(f => f.columnId === target.columnId);
      const sourceColumn = layer.columns.find(f => f.columnId === source.id);
      if (!targetColumn || !sourceColumn) return;
      columns = (0, _utils.reorderElements)(layer.columns, targetColumn, sourceColumn);
      break;
  }
  if (!columns) return;
  const newState = {
    ...props.state,
    layers: {
      ...props.state.layers,
      [target.layerId]: {
        ...layer,
        columns,
        allColumns
      }
    }
  };
  if ((0, _types.isOperation)(source) && ['replace_compatible', 'move_compatible'].includes(dropType)) {
    return (0, _remove_column.removeColumn)({
      prevState: newState,
      columnId: source.columnId,
      layerId: source.layerId
    });
  }
  return newState;
};
exports.onDrop = onDrop;