"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLDataGridAccordion = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _public = require("@kbn/esql-datagrid/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESQLDataGridAccordion = ({
  isAccordionOpen,
  dataGridAttrs,
  query,
  isTableView,
  setIsAccordionOpen,
  onAccordionToggleCb
}) => {
  const onAccordionToggle = (0, _react.useCallback)(status => {
    setIsAccordionOpen(!isAccordionOpen);
    onAccordionToggleCb(status);
  }, [isAccordionOpen, onAccordionToggleCb, setIsAccordionOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isAccordionOpen ? 1 : false,
    "data-test-subj": "ESQLQueryResults",
    css: (0, _react2.css)`
        .euiAccordion__childWrapper {
          flex: ${isAccordionOpen ? 1 : 'none'};
        }
        padding: 0 ${_uiTheme.euiThemeVars.euiSize};
        border-bottom: ${_uiTheme.euiThemeVars.euiBorderThin};
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "esql-results",
    css: (0, _react2.css)`
          .euiAccordion__children {
            display: flex;
            flex-direction: column;
            height: 100%;
          }
        `,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: (0, _react2.css)`
                padding: 2px;
              }
            `
    }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.lens.config.ESQLQueryResultsTitle', {
      defaultMessage: 'ES|QL Query Results'
    }))),
    buttonProps: {
      paddingSize: 'm'
    },
    initialIsOpen: isAccordionOpen,
    forceState: isAccordionOpen ? 'open' : 'closed',
    onToggle: onAccordionToggle,
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      size: "m",
      color: "subdued"
    }, dataGridAttrs.rows.length)
  }, isAccordionOpen && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.ESQLDataGrid, {
    rows: dataGridAttrs === null || dataGridAttrs === void 0 ? void 0 : dataGridAttrs.rows,
    columns: dataGridAttrs === null || dataGridAttrs === void 0 ? void 0 : dataGridAttrs.columns,
    dataView: dataGridAttrs === null || dataGridAttrs === void 0 ? void 0 : dataGridAttrs.dataView,
    query: query,
    flyoutType: "overlay",
    isTableView: isTableView,
    initialRowHeight: 0,
    controlColumnIds: ['openDetails']
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))));
};
exports.ESQLDataGridAccordion = ESQLDataGridAccordion;