"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_LENS_LAYOUT_DIMENSIONS = void 0;
exports.getLocatorParams = getLocatorParams;
exports.getShareURL = getShareURL;
var _utils = require("../utils");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This approximate Lens workspace dimensions ratio on a typical widescreen
const DEFAULT_LENS_LAYOUT_DIMENSIONS = exports.DEFAULT_LENS_LAYOUT_DIMENSIONS = {
  width: 1793,
  // this is a magic number from the reporting tool implementation
  // see: x-pack/platform/plugins/shared/screenshotting/server/browsers/chromium/driver_factory/index.ts#L146
  height: 1086
};
function getShareURLForSavedObject({
  application,
  data
}, currentDoc) {
  return new URL(`${application.getUrlForApp('lens', {
    absolute: true
  })}${currentDoc !== null && currentDoc !== void 0 && currentDoc.savedObjectId ? (0, _constants.getEditPath)(currentDoc === null || currentDoc === void 0 ? void 0 : currentDoc.savedObjectId, data.query.timefilter.timefilter.getTime(), data.query.filterManager.getGlobalFilters(), data.query.timefilter.timefilter.getRefreshInterval()) : ''}`);
}
function getLocatorParams(data, {
  filters,
  query,
  activeDatasourceId,
  datasourceStates,
  datasourceMap,
  visualizationMap,
  visualization,
  adHocDataViews,
  currentDoc
}, isDirty) {
  const references = (0, _utils.extractReferencesFromState)({
    activeDatasources: Object.keys(datasourceStates).reduce((acc, datasourceId) => ({
      ...acc,
      [datasourceId]: datasourceMap[datasourceId]
    }), {}),
    datasourceStates,
    visualizationState: visualization.state,
    activeVisualization: visualization.activeId ? visualizationMap[visualization.activeId] : undefined
  });
  const serializableVisualization = visualization;
  const serializableDatasourceStates = datasourceStates;
  const snapshotParams = {
    filters,
    query,
    resolvedDateRange: (0, _utils.getResolvedDateRange)(data.query.timefilter.timefilter),
    visualization: serializableVisualization,
    datasourceStates: serializableDatasourceStates,
    activeDatasourceId,
    searchSessionId: data.search.session.getSessionId(),
    references,
    dataViewSpecs: adHocDataViews
  };
  return {
    shareURL: snapshotParams,
    // for reporting use the shorten version when available
    reporting: currentDoc !== null && currentDoc !== void 0 && currentDoc.savedObjectId && !isDirty ? {
      filters,
      query,
      resolvedDateRange: (0, _utils.getResolvedDateRange)(data.query.timefilter.timefilter),
      savedObjectId: currentDoc === null || currentDoc === void 0 ? void 0 : currentDoc.savedObjectId
    } : snapshotParams
  };
}
async function getShareURL(shortUrlService, services, configuration, shareUrlEnabled, isDirty) {
  const {
    shareURL: locatorParams,
    reporting: reportingLocatorParams
  } = getLocatorParams(services.data, configuration, isDirty);
  return {
    shareableUrl: await (shareUrlEnabled ? shortUrlService(locatorParams) : undefined),
    savedObjectURL: getShareURLForSavedObject(services, configuration.currentDoc),
    reportingLocatorParams
  };
}