"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventTypeSchema = exports.eventSchema = exports.annotationEventSchema = exports.alertEventSchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const eventTypeSchema = exports.eventTypeSchema = _zod.z.union([_zod.z.literal('annotation'), _zod.z.literal('alert'), _zod.z.literal('error_rate'), _zod.z.literal('latency'), _zod.z.literal('anomaly')]);
const sourceSchema = _zod.z.record(_zod.z.string(), _zod.z.any());
const annotationEventSchema = exports.annotationEventSchema = _zod.z.object({
  eventType: _zod.z.literal('annotation'),
  id: _zod.z.string(),
  title: _zod.z.string(),
  description: _zod.z.string(),
  timestamp: _zod.z.number(),
  source: sourceSchema.optional(),
  annotationType: _zod.z.string().optional()
});
const alertStatusSchema = _zod.z.union([_zod.z.literal('active'), _zod.z.literal('flapping'), _zod.z.literal('recovered'), _zod.z.literal('untracked')]);
const alertEventSchema = exports.alertEventSchema = _zod.z.object({
  eventType: _zod.z.literal('alert'),
  id: _zod.z.string(),
  title: _zod.z.string(),
  description: _zod.z.string(),
  timestamp: _zod.z.number(),
  source: sourceSchema.optional(),
  alertStatus: alertStatusSchema
});
const eventSchema = exports.eventSchema = _zod.z.discriminatedUnion('eventType', [annotationEventSchema, alertEventSchema]);